<?php

namespace Modules\Store\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UnitRequest extends FormRequest
{
    public function rules()
    {
        $code = auth()->user()->language_code;
        if (isModuleActive('FrontendMultiLang')) {
            return [
                'name.' . $code => [
                    'required'
                ]
            ];
        } else {
            return [
                'name.' . $code => [
                    'required',
                ]
            ];
        }
    }

    public function messages()
    {
        if (isModuleActive('FrontendMultiLang')) {
            return validationMessage([
                'name.*.required' => 'The Unit name is required',
                'name.*.unique_translation' => 'The Unit name has already been taken',
            ]);
        } else {
            return validationMessage([
                'name.required' => 'The Unit name is required',
                'name.unique' => 'The Unit name has already been taken',
            ]);
        }
    }

    public function authorize()
    {
        return true;
    }
}
