<?php

namespace Modules\Store\Http\Controllers;

use Brian2694\Toastr\Facades\Toastr;
use Illuminate\Routing\Controller;
use Modules\Store\Http\Requests\RefundReasonRequest;
use Modules\Store\Services\RefundReasonService;

class RefundReasonController extends Controller
{
    protected $refundReasonService;

    public function __construct(RefundReasonService $refundReasonService)
    {
        $this->refundReasonService = $refundReasonService;
    }

    public function index()
    {
        $data['items'] = $this->refundReasonService->getAll();
        return view('store::refund.refund_reasons.refund_list', $data);
    }

    public function edit($id)
    {
        $data['edit'] = $this->refundReasonService->getById($id);
        $data['items'] = $this->refundReasonService->getAll();
        return view('store::refund.refund_reasons.index', $data);
    }

    public function reasons_list()
    {
        $data['items'] = $this->refundReasonService->getAll();
        return view('store::refund.refund_reasons.index', $data);
    }

    public function store(RefundReasonRequest $request)
    {
        try {
            $this->refundReasonService->save($request->except("_token"));

            Toastr::success(trans('common.Operation successful'), trans('common.Success'));
            return redirect()->route('store.refundreason.index');
        } catch (\Exception $e) {
            Toastr::error(trans('common.Operation failed'), trans('common.Failed'));
            return redirect()->back();
        }
    }

    public function update(RefundReasonRequest $request, $id)
    {
        try {
            $this->refundReasonService->update($request->except("_token"), $id);
            Toastr::success(trans('common.Operation successful'), trans('common.Success'));
            return redirect()->route('store.refundreason.index');
        } catch (\Exception $e) {
            Toastr::error(trans('common.Operation failed'), trans('common.Failed'));
            return redirect()->back();
        }
    }

    public function destroy($id)
    {
        try {
            $this->refundReasonService->delete($id);
            Toastr::success(trans('common.Operation successful'), trans('common.Success'));
            return redirect()->route('store.refundreason.index');
        } catch (\Exception $e) {
            Toastr::error(trans('common.Operation failed'), trans('common.Failed'));
            return redirect()->back();
        }
    }
}
