<?php

namespace Modules\Store\Http\Controllers;

use Illuminate\Routing\Controller;
use Brian2694\Toastr\Facades\Toastr;
use Modules\Store\Http\Requests\PublicationRequest;
use Modules\Store\Repositories\PublicationRepository;
use Illuminate\Foundation\Validation\ValidatesRequests;

class PublicationController extends Controller
{
    use ValidatesRequests;

    protected $publicationRepository;

    public function __construct(PublicationRepository $publicationRepository)
    {
        $this->publicationRepository = $publicationRepository;
    }

    public function index()
    {
        try {

            $data['publications'] = $this->publicationRepository->getAll();
            return view('store::publication.index', compact('data'));
        } catch (\Exception $e) {
            GettingError($e->getMessage(), url()->current(), request()->ip(), request()->userAgent());
        }
    }

    public function create()
    {
        return view('store::create');
    }

    public function store(PublicationRequest $request)
    {
        if (demoCheck()) {
            return redirect()->back();
        }

        $unit = $this->publicationRepository->store($request);
        if ($unit) {
            Toastr::success(trans('common.Operation successful'), trans('common.Success'));
            return redirect()->back();
        } else {
            Toastr::error(trans('common.Operation failed'), trans('common.Failed'));
            return redirect()->back();
        }
    }

    public function edit($id)
    {
        try {

            $data['publications'] = $this->publicationRepository->getAll();
            $data['edit'] = $this->publicationRepository->getById($id);
            return view('store::publication.index', compact('data'));
        } catch (\Exception $e) {
            GettingError($e->getMessage(), url()->current(), request()->ip(), request()->userAgent());
        }
    }


    public function update(PublicationRequest $request)
    {
        if (demoCheck()) {
            return redirect()->back();
        }

        $unit = $this->publicationRepository->update($request);
        if ($unit) {
            Toastr::success(trans('common.Operation successful'), trans('common.Success'));
            return redirect()->route('store.publication.index');
        } else {
            Toastr::error(trans('common.Operation failed'), trans('common.Failed'));
            return redirect()->back();
        }
    }

    public function destroy($id)
    {
        if (demoCheck()) {
            return redirect()->back();
        }
        try {

            $unit_delete = $this->publicationRepository->destroy($id);
            if ($unit_delete) {
                Toastr::success(trans('common.Operation successful'), trans('common.Success'));
                return redirect()->back();
            } else {
                Toastr::error(trans('common.Operation failed'), trans('common.Failed'));
                return redirect()->back();
            }
        } catch (\Exception $e) {
            GettingError($e->getMessage(), url()->current(), request()->ip(), request()->userAgent());
        }
    }
}
