<?php

namespace Modules\Store\Entities;

use App\BillingDetails;
use App\User;
use Illuminate\Database\Eloquent\Model;
use Modules\Payment\Entities\Checkout;

class RefundRequest extends Model
{
    protected $guarded = ['id'];
    protected $appends = ['CheckConfirmed','OrderNumber'];

    public function bank_payments()
    {
        return $this->morphOne(StoreBankPayment::class, 'itemable');
    }

    public function refund_details()
    {
        return $this->hasMany(RefundRequestDetail::class);
    }

    public function order()
    {
        return $this->belongsTo(Checkout::class, 'order_id', 'id');
    }

    public function customer()
    {
        return $this->belongsTo(User::class, 'customer_id', 'id');
    }

    public function shipping_gateway()
    {
        return $this->belongsTo(ShippingMethod::class, 'shipping_method_id')->withDefault();
    }
   public function pick_up_address_customer()
    {
        return $this->belongsTo(BillingDetails::class, 'pick_up_address_id')->withDefault();
    }

    public function refund_images()
    {
        return $this->hasMany(ImageRefundRequest::class);
    }

    public function getCheckConfirmedAttribute()
    {
        if ($this->is_confirmed == 1) {
            return "Confirmed";
        } elseif ($this->is_confirmed == 2) {
            return "Cancelled";
        } else {
            return "Pending";
        }
    }

    public function getOrderNumberAttribute()
    {
        return $this->order?->order_number;
    }


}
