<?php

namespace Modules\Store\Entities;

use App\User;
use Illuminate\Database\Eloquent\Model;
use App\Traits\HasTranslations;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class ProductAttribute extends Model
{
    use HasFactory, HasTranslations;

    protected $table = "product_attributes";
    protected $guarded = ['id'];
    public $translatable = ['title', 'description'];

    public function user()
    {
        return $this->belongsTo(User::class)->withDefault();
    }

    public function values()
    {
        return $this->hasMany(ProductAttributeValue::class);
    }

}
