<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateProductVariantsTable extends Migration
{
    public function up()
    {
        Schema::create('product_variants', function (Blueprint $table) {
            $table->increments('id');
            $table->timestamps();
            $table->unsignedBigInteger("product_sku_id")->nullable();
            $table->unsignedBigInteger("attribute_id")->nullable();
            $table->unsignedBigInteger("attribute_value_id")->nullable();
            $table->unsignedBigInteger("product_id")->nullable();
            $table->boolean("status")->default(1);
        });
    }

    public function down()
    {
        Schema::dropIfExists('product_variants');
    }
}
