<?php

use Illuminate\Support\Facades\Route;

Route::prefix('noticeboard')->as('noticeboard.')->group(function () {
    Route::get('/', 'NoticeboardController@index')->name('index')->middleware('RoutePermissionCheck:noticeboard.index');
    Route::post('/store', 'NoticeboardController@store')->name('store')->middleware('RoutePermissionCheck:noticeboard.store');
    Route::post('/update', 'NoticeboardController@update')->name('update')->middleware('RoutePermissionCheck:noticeboard.update');
    Route::post('/delete', 'NoticeboardController@delete')->name('delete')->middleware('RoutePermissionCheck:noticeboard.delete');


    Route::get('/type', 'NoticeboardTypeController@index')->name('type.index')->middleware('RoutePermissionCheck:noticeboard.type.index');
    Route::post('/type/store', 'NoticeboardTypeController@store')->name('type.store')->middleware('RoutePermissionCheck:noticeboard.type.store');
    Route::post('/type/update', 'NoticeboardTypeController@update')->name('type.update')->middleware('RoutePermissionCheck:noticeboard.type.update');
    Route::post('/type/delete', 'NoticeboardTypeController@delete')->name('type.delete')->middleware('RoutePermissionCheck:noticeboard.type.delete');

    Route::get('/course', 'CourseNoticeboardController@index')->name('course.index')->middleware('RoutePermissionCheck:noticeboard.course.index');
    Route::post('/course/store', 'CourseNoticeboardController@store')->name('course.store')->middleware('RoutePermissionCheck:noticeboard.course.store');
    Route::post('/course/update', 'CourseNoticeboardController@update')->name('course.update')->middleware('RoutePermissionCheck:noticeboard.course.update');
    Route::post('/course/delete', 'CourseNoticeboardController@delete')->name('course.delete')->middleware('RoutePermissionCheck:noticeboard.course.delete');

    Route::post('/find-by-id', 'CourseNoticeboardController@show')->name('findById')->middleware('RoutePermissionCheck:noticeboard.course.index');


});
