@extends('backend.master')

@php
    $table_name='notice_types';
@endphp
@section('table')
    {{$table_name}}
@endsection

@section('mainContent')

    {!! generateBreadcrumb() !!}

    <section class="admin-visitor-area up_st_admin_visitor">
        <div class="container-fluid p-0">
            <div class="white-box">
                <div class="row justify-content-center">
                    <div class="col-12">
                        <div class="box_header common_table_header">
                            <div class="main-title d-md-flex">
                                <h3 class="mb-0 mr-30 mb_xs_15px mb_sm_20px"
                                    id="page_title">{{__('noticeboard.Notice Type')}}</h3>

                                <ul class="d-flex">
                                    @if (permissionCheck('noticeboard.type.store'))
                                        <li>
                                            <a class="primary-btn radius_30px fix-gr-bg" data-bs-toggle="modal"
                                               id=""
                                               data-bs-target="#add_type" href="#"><i
                                                    class="ti-plus"></i>{{__('common.Add')}} {{__('noticeboard.Notice Type')}}
                                            </a>
                                        </li>
                                    @endif
                                </ul>

                            </div>
                        </div>
                    </div>
                    <div class="col-lg-12">
                        <div class="QA_section QA_section_heading_custom check_box_table">
                            <div class="QA_table ">
                                <div class="">
                                    <table id="lms_table" class="table Crm_table_active3">
                                        <thead>
                                        <tr>
                                            <th scope="col">{{__('common.SL')}}</th>
                                            <th scope="col">{{__('common.Title')}}</th>
                                            <th scope="col">{{__('common.Color')}}</th>
                                            <th scope="col">{{__('common.Status')}}</th>
                                            <th scope="col">{{__('common.Action')}}</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        @foreach($types as $key=>$type)
                                            <tr>
                                                <td>{{translatedNumber(++$key)}}</td>
                                                <td>{{$type->title}}</td>
                                                <td>
                                                    <div
                                                        style="background: {{$type->color}};height: 30px;width: 50px"></div>
                                                </td>
                                                <td class="nowrap">
                                                    <x-backend.status :id="$type->id" :status="$type->status"
                                                                      :route="'noticeboard.type.changeStatus'"></x-backend.status>

                                                </td>
                                                <td>
                                                    @include('noticeboard::type._action',compact('type'))
                                                </td>
                                            </tr>
                                        @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </section>


    @include('noticeboard::type._add_modal')
    @include('noticeboard::type._edit_modal')
    @include('noticeboard::type._delete_modal')
@endsection
@push('scripts')
    <script src="{{asset('Modules/Noticeboard/Resources/assets/js/script.js')}}"></script>

    <script type="application/javascript">
        (function ($) {
            "use strict";

            dataTableOptions = updateColumnExportOption(dataTableOptions, [0, 1]);

            $('#lms_table').DataTable(dataTableOptions);
        })(jQuery);


    </script>
@endpush
