<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateInstallmentCartsTable extends Migration
{
    public function up()
    {
        Schema::create('installment_carts', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('course_id');
            $table->integer('user_id');
            $table->integer('instructor_id');
            $table->string('tracking');
            $table->float('price');
            $table->integer('plan_id');
            $table->string('step')->default(1)->comment('1: upfront, 2: installment');
            $table->longText('installment_data')->nullable();
            $table->bigInteger('purchase_id')->nullable()->comment('installment_purchase_id');
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('installment_carts');
    }
}
