<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateUserCashbackDetailsTable extends Migration
{

    public function up()
    {
        Schema::create('user_cashback_details', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_cashback_id');
            $table->foreign('user_cashback_id')->references('id')->on('user_cashbacks')->onDelete('cascade');

            $table->unsignedBigInteger('rule_id');
            $table->foreign('rule_id')->references('id')->on('cashback_rules')->onDelete('cascade');

            $table->string('product_type')->comment('course, bundle, subscription, etc');
            $table->integer('product_id');
            $table->double('purchase_amount');
            $table->double('cashback_amount');
            $table->timestamp('cashback_datetime')->nullable();
            $table->string('description')->nullable();
            $table->string('status')->default('paid')->comment('paid,refunded');
            $table->timestamp('refunded_datetime')->nullable();
            $table->string('refunded_description')->nullable();
            $table->integer('is_gift')->nullable()->default(0);
            $table->integer('gift_id')->nullable();
            $table->integer('gifted_to')->nullable();
            $table->integer('subscription_enrolled_id')->nullable();
            $table->timestamps();
        });
    }


    public function down()
    {
        Schema::dropIfExists('user_cashback_details');
    }
}
