<?php

namespace Modules\Assignment\Http\Controllers;

use App\User;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Brian2694\Toastr\Facades\Toastr;
use Modules\Assignment\Entities\InfixAssignment;
use Modules\Assignment\Entities\InfixAssignAssignment;

class AssignAssignmentController extends Controller
{

    public function assign($id)
    {
        $assignment = InfixAssignment::find($id);
        $students = User::where('role_id', 3)->where('status', 1)->get();
        $assigned = InfixAssignAssignment::where('assignment_id', $id)->get();
        $assigned_students = [];
        foreach ($assigned as $key => $assign) {
            $assigned_students[$key] = $assign->student_id;
        }
        return view('assignment::assign', compact('assignment', 'students', 'assigned_students'));
    }

    public function assignStore(Request $request)
    {
        try {
            // return $request;
            if ($request->to != null) {
                foreach ($request->to as $key => $student_id) {
                    $check_assign = InfixAssignAssignment::where('assignment_id', $request->assignment_id)->where('student_id', $student_id)->first();
                    if ($check_assign == null) {
                        $assign = new InfixAssignAssignment();
                        $assign->assignment_id = $request->assignment_id;
                        $assign->student_id = $student_id;
                        $assign->save();
                    }
                }
                Toastr::success(trans('common.Operation successful'), trans('common.Success'));
                return redirect()->route('assignment_list');
            }
            if ($request->from != null) {
                foreach ($request->from as $key => $student_id) {
                    $check_assign = InfixAssignAssignment::where('assignment_id', $request->assignment_id)->where('student_id', $student_id)->delete();

                }
                Toastr::success(trans('common.Operation successful'), trans('common.Success'));
                return redirect()->route('assignment_list');
            }
            Toastr::error(trans('common.Operation failed'), trans('common.Failed'));
            return redirect()->back();
        } catch (\Exception $e) {
            Toastr::error(trans('common.Operation failed'), trans('common.Failed'));
            return redirect()->back();
        }
    }
}
