<div class="row">
    <div class="col-xl-4">
        <label class="primary_input_label"
               for="category">{{ __('courses.Category') }}</label>
        <select class="primary_select teachingCategory" data-serial_id="0" name="teachingCategory[0][category]"
                id="teachingCategory"
            {{ $errors->has('category') ? 'autofocus' : '' }}>
            <option data-display="{{ __('common.Select') }} {{ __('quiz.Category') }} "
                    value="">{{ __('common.Select') }} {{ __('quiz.Category') }} </option>
            @foreach ($categories as $category)
                <option value="{{ $category->id }}">{{ @$category->name }} </option>
            @endforeach
        </select>
    </div>

    <div class="col-xl-4 courseBox mt-30 teachingSubCategoryDiv" id="teachingSubCategoryDiv_0">
        <select class="primary_select teachingSubCategory" name="teachingCategory[0][sub_category]"
                id="teachingSubCategory_0"
            {{ $errors->has('sub_category') ? 'autofocus' : '' }}>
            <option
                data-display="{{ __('common.Select') }} {{ __('courses.Sub Category') }}  "
                value="">{{ __('common.Select') }} {{ __('courses.Sub Category') }}
            </option>
        </select>
    </div>

    <div class="col-xl-3">
        <label class="primary_input_label"
               for="category">{{ __('courses.Level') }}</label>
        <select class="primary_select" name="teachingCategory[0][level]" id="category">
            <option data-display="{{ __('appointment.Select Level') }}" value="">
                {{ __('appointment.Select Level') }}</option>
            @foreach ($levels as $level)
                <option value="{{ $level->id }}">{{ @$level->title }} </option>
            @endforeach
        </select>
    </div>
    <div class="col-xl-1 mt-33">
        <button class="removeTeachingCategoryBtn primary-btn icon-only fix-gr-bg fl-r"
                type="button">
            <span class="ti-trash"></span></button>
    </div>
</div>
@push('scripts')
    <script>
        (function ($) {
            "use strict";

            $(document).on('change', '.teachingCategory', function () {
                let url = $("#url").val();
                let category_id = $(this).val();
                var lang = window._locale;
                let serial_id = $(this).data('serial_id');
                var formData = {
                    id: $(this).val(),
                };
                console.log(formData);
                // get section for student
                $.ajax({
                    type: "GET",
                    data: formData,
                    dataType: "json",
                    url: url + "/" + "admin/course/ajaxGetCourseSubCategory",
                    success: function (data) {
                        // console.log(data);
                        var a = "";
                        $.each(data, function (i, item) {
                            if (item.length) {
                                $("#teachingSubCategory_" + serial_id).find("option").not(":first").remove();
                                $("#teachingSubCategoryDiv_" + serial_id + " ul").find("li").not(":first").remove();

                                $.each(item, function (i, subCategory) {
                                    $("#teachingSubCategory_" + serial_id).append(
                                        $("<option>", {
                                            value: subCategory.id,
                                            text: subCategory.name[lang],
                                        })
                                    );

                                    $("#teachingSubCategoryDiv_" + serial_id + " ul").append(
                                        "<li data-value='" +
                                        subCategory.id +
                                        "' class='option'>" +
                                        subCategory.name[lang] +
                                        "</li>"
                                    );
                                });
                            } else {
                                $("#teachingSubCategoryDiv_" + serial_id + " .current").html("Select Sub Category");
                                $("#teachingSubCategory_" + serial_id).find("option").not(":first").remove();
                                $("#teachingSubCategoryDiv_" + serial_id + " ul").find("li").not(":first").remove();
                            }
                        });
                        // console.log(a);
                    },
                    error: function (data) {
                        console.log("Error:", data);
                    },
                });
            });
        })(jQuery);
    </script>

@endpush
