<h4 class='border-bottom'>{{ __('appointment.What Students Say') }}</h4>
<div class="course_details_inner_student_feedback_rating">
    <div>
        <div class="course_details_inner_student_feedback_rating_counts">
            <h3>{{ number_format($instructor->avgRating(), 1) }}</h3>
            @php
                $main_stars = $instructor->avgRating();
                $stars = intval($instructor->avgRating());
            @endphp
            <div class="star">
                @for ($i = 0; $i < $stars; $i++)
                    <i class="fa fa-star"></i>
                @endfor
                @if ($main_stars > $stars)
                    <i class="fa fa-star-half-alt"></i>
                @endif
                @if (5 > $stars && $main_stars != 0)
                    @php
                        $uncheckStar = 5 - $stars;
                    @endphp
                    @for ($i = 1; $i < $uncheckStar; $i++)
                        <i class="fa fa-star unchecked"></i>
                    @endfor
                    @if ($uncheckStar == 1)
                        <i class="fa fa-star unchecked"></i>
                    @endif
                @endif
                @if ($main_stars == 0)
                    @for ($i = 0; $i < 5; $i++)
                        <i class="fa fa-star unchecked"></i>
                    @endfor
                @endif

            </div>
            <p>{{ __('appointment.Rating') }}</p>
        </div>
    </div>
    <div>
        <div class="progress">
            <div class="progress-bar" role="progressbar" aria-valuenow="{{ $count_5 }}" aria-valuemin="0"
                 aria-valuemax="100">
            </div>
        </div>
        <div class="progress">
            <div class="progress-bar" role="progressbar" aria-valuenow="{{ $count_4 }}" aria-valuemin="0"
                 aria-valuemax="100">
            </div>
        </div>
        <div class="progress">
            <div class="progress-bar" role="progressbar" aria-valuenow="{{ $count_3 }}" aria-valuemin="0"
                 aria-valuemax="100">
            </div>
        </div>
        <div class="progress">
            <div class="progress-bar" role="progressbar" aria-valuenow="{{ $count_2 }}" aria-valuemin="0"
                 aria-valuemax="100">
            </div>
        </div>
        <div class="progress">
            <div class="progress-bar" role="progressbar" aria-valuenow="{{ $count_1 }}" aria-valuemin="0"
                 aria-valuemax="100">
            </div>
        </div>
    </div>
    <div>
        <div class="star">
            <i class="fa fa-star"></i>
            <i class="fa fa-star"></i>
            <i class="fa fa-star"></i>
            <i class="fa fa-star"></i>
            <i class="fa fa-star"></i>
            <span>{{ number_format($count_5, 1) }}%</span>
        </div>
        <div class="star">
            <i class="fa fa-star"></i>
            <i class="fa fa-star"></i>
            <i class="fa fa-star"></i>
            <i class="fa fa-star"></i>
            <i class="fa fa-star unchecked"></i>
            <span>{{ number_format($count_4, 1) }}%</span>
        </div>
        <div class="star">
            <i class="fa fa-star"></i>
            <i class="fa fa-star"></i>
            <i class="fa fa-star"></i>
            <i class="fa fa-star unchecked"></i>
            <i class="fa fa-star unchecked"></i>
            <span>{{ number_format($count_3, 1) }}%</span>
        </div>
        <div class="star">
            <i class="fa fa-star"></i>
            <i class="fa fa-star"></i>
            <i class="fa fa-star unchecked"></i>
            <i class="fa fa-star unchecked"></i>
            <i class="fa fa-star unchecked"></i>
            <span>{{ number_format($count_2, 1) }}%</span>
        </div>
        <div class="star">
            <i class="fa fa-star"></i>
            <i class="fa fa-star unchecked"></i>
            <i class="fa fa-star unchecked"></i>
            <i class="fa fa-star unchecked"></i>
            <i class="fa fa-star unchecked"></i>
            <span>{{ number_format($count_1, 1) }}%</span>
        </div>
    </div>
</div>
<div class="course_details_inner_student_reviews_items">

    @php
        $instructorId = $instructor->id;
    @endphp
    @if (Auth::check() && auth()->user()->role_id == 3)
        <div class="course_review_header mb_20">
            <div class="row align-items-center">
                <div class="col-md-6">
                    <div class="review_poients">
                        @if ($isBooked && !$hasOneReview)
                            <p class="theme_color font_16 mb-0">
                                {{ __('frontend.Be the first reviewer') }}</p>
                        @endif
                    </div>
                </div>

                @if ($isBooked && !$hasOneReview)
                    <div class="col-md-6">
                        <div class="rating_star text-end">

                            @php
                                $PickId = $instructor->id;
                            @endphp
                            @if (1==1)
                                <div class="star_icon d-flex align-items-center justify-content-end">
                                    <a class="rating">
                                        <input type="radio" id="star5" name="rating" value="5"
                                               class="rating"/><label class="full" for="star5" id="star5"
                                                                      title="Awesome - 5 stars"
                                                                      onclick="instructorReview(5, {{ @$PickId }})"></label>

                                        <input type="radio" id="star4" name="rating" value="4"
                                               class="rating"/><label class="full" for="star4"
                                                                      title="Pretty good - 4 stars"
                                                                      onclick="instructorReview(4, {{ @$PickId }})"></label>

                                        <input type="radio" id="star3" name="rating" value="3"
                                               class="rating"/><label class="full" for="star3"
                                                                      title="Meh - 3 stars"
                                                                      onclick="instructorReview(3, {{ @$PickId }})"></label>

                                        <input type="radio" id="star2" name="rating" value="2"
                                               class="rating"/><label class="full" for="star2"
                                                                      title="Kinda bad - 2 stars"
                                                                      onclick="instructorReview(2, {{ @$PickId }})"></label>

                                        <input type="radio" id="star1" name="rating" value="1"
                                               class="rating"/><label class="full" for="star1"
                                                                      title="Bad  - 1 star"
                                                                      onclick="instructorReview(1,{{ @$PickId }})"></label>

                                    </a>
                                </div>
                            @else
                                <p class="font_14 f_w_400 mt-0"><a href="{{ url('login') }}"
                                                                   class="theme_color2">{{ __('frontend.Sign In') }}</a>
                                    {{ __('frontend.or') }} <a class="theme_color2"
                                                               href="{{ url('register') }}">{{ __('frontend.Sign Up') }}</a>
                                    {{ __('frontend.as student to post a review') }}</p>
                            @endif
                        </div>
                    </div>
                @endif
            </div>
        </div>
    @endif
    @foreach ($instructor->instructorReviews as $review)
        <div class="course_details_inner_reviews_card">
            <div class="course_details_inner_reviews_card_user">
                <div>
                    <div class="course_details_inner_reviews_card_user_img">
                        <img class="w-100" src="{{ asset($review->user->image) }}" alt="">
                    </div>
                </div>
                <div>
                    <div class="course_details_inner_reviews_card_user_content">
                        <h4>{{ $review->user->name }}</h4>
                        <div class="star">
                            @php
                                $starts = number_format($review->star) ?? 0;
                                $notStart = 5-$starts;
                            @endphp
                            @for ($i = 0; $i < $starts; $i++)
                                <i class="fa fa-star"></i>
                            @endfor
                            @for ($i = 0; $i < $notStart; $i++)
                                <i class="fa fa-star unchecked"></i>
                            @endfor

                            <span>{{ $review->recentReview }}</span>
                        </div>
                        <p>{{ $review->comment }}</p>
                    </div>
                </div>
            </div>
        </div>
    @endforeach

</div>

@if (count($instructor->instructorReviews) > 10)
    <a href="#" class=" small_btn d-block text-center">{{ __('appointment.See More Reviews') }}</a>
@endif
{{-- modal for review --}}

<div class="modal cs_modal fade admin-query" id="instructorReviewModal" role="dialog">
    <div class="modal-dialog modal-lg modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">{{ __('frontend.Review') }}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"><i
                        class="ti-close closeModal"></i></button>
            </div>
            <form action="{{ route('appointment.submitReview') }}" method="Post">
                <div class="modal-body">
                    @csrf
                    <input type="hidden" name="instructor_id" id="rating_instructor_id" value="">
                    <input type="hidden" name="star" id="rating_value" value="">

                    <div class="text-center">
                        <textarea class="lms_summernote" name="comment" id=""
                                  placeholder="{{ __('frontend.Write your review') }}" cols="30"
                                  rows="10">{{ old('review') }}</textarea>
                        <span class="text-danger" role="alert">{{ $errors->first('review') }}</span>
                    </div>
                </div>
                <div class="modal-footer">
                    <div class="mt-40 d-flex justify-content-between">
                        <button type="button" class="theme_line_btn me-2 closeModal"
                                data-bs-dismiss="modal">{{ __('common.Cancel') }}
                        </button>
                        <button class="theme_btn " type="submit">{{ __('common.Submit') }}</button>
                    </div>
                </div>
            </form>

        </div>
    </div>
</div>

<script>
    (function ($) {
        "use strict";

        function instructorReview(rating, instructor) {
            $('#instructorReviewModal').modal('show');
            $('.modal-backdrop').removeClass('modal-backdrop');
            $('#rating_instructor_id').val(instructor);
            $('#rating_value').val(rating);
        }

        $(document).on('click', '.closeModal', function () {
            $('#instructorReviewModal').modal('hide');
        })
    })(jQuery);

</script>

