@php
$tz = isset($userTimeZone) ? $userTimeZone : Settings('active_time_zone');
@endphp

@foreach ($periods as $date)
    <div id="calender_date">
        @php
            $teachingInfo = Modules\Appointment\Entities\Schedule::teachingInfo('no_slot', $date->format('Y-m-d'), $instructor->id, 'get');
        @endphp
        <div id="header" {{ count($teachingInfo) == 0 ? 'event-offday' : '' }}>
            <span>{{ $date->format('l') }}</span>
            <h4>{{ $date->format('d') }}</h4>
        </div>

        @foreach ($teachingInfo as $key => $scheduleInfo)
            <div id="event_date">
                <a href="{{route('appointment.checkout',['my_slot'=>$scheduleInfo->id])}}">
                <button class="scheduleBook">
                   
                    {{ \Carbon\Carbon::parse($date->format('Y-m-d') . ' ' . $scheduleInfo->slotInfo->start_time)->setTimeZone($tz)->format('h:i A') }}
                    -
                    {{ \Carbon\Carbon::parse($date->format('Y-m-d') . ' ' . $scheduleInfo->slotInfo->end_time)->setTimeZone($tz)->format('h:i A') }}    
                </button>
            </a>

            </div>
        @endforeach
    </div>
@endforeach
