<?php
namespace Modules\Appointment\Repositories\Eloquents;

use App\Repositories\Eloquents\BaseRepository;
use App\User;
use Illuminate\Database\Eloquent\Model;
use Modules\Appointment\Entities\InstructorTeachingCategory;
use Modules\Appointment\Entities\RequestPost;
use Modules\Appointment\Entities\Wishlist;
use Modules\Appointment\Repositories\Interfaces\PostRequestRepositoryInterface;
use Modules\CourseSetting\Entities\Category;

class PostRequestRepository extends BaseRepository implements PostRequestRepositoryInterface
{
    protected $wishlist;
    public function __construct(
        RequestPost $model,
        User $user,
        Category $category,
        Wishlist $wishlist,
        InstructorTeachingCategory $teachingCategory
    ) {
        parent::__construct($model);
        $this->user = $user;
        $this->wishlist = $wishlist;
        $this->category = $category;
        $this->teachingCategory = $teachingCategory;
    }
    public function index(): array
    {
        $data['postRequests'] = $this->model->where('status', 1)->get();
        return $data;
    }
    public function create(array $payload): ?Model
    {
        return $this->model->create($this->formatParams($payload));
    }

    public function edit($modelId): array
    {
        $data = [];
        return $data;
    }
    private function formatParams(array $payload, $modelId = null)
    {
        $formatParam = [
            'teaching_category' => gv($payload, 'teaching_category'),
            'requirement' => gv($payload, 'requirement'),
            'min_price' => gv($payload, 'min_price'),
            'max_price' => gv($payload, 'max_price'),
            'headline' => gv($payload, 'headline'),
            'name' => gv($payload, 'name'),
            'email' => gv($payload, 'email'),
            'user_id' => auth()->user()->id,
        ];
        return $formatParam;
    }
    public function shareInstructor($id): array
    {
        $data = [];
        $post = $this->findById($id);
        $data['post'] = $post;
        $data['categories'] = $this->category->where('status', 1)->get();
        $data['instructors'] = $this->user->when($post->min_price && $post->max_price, function ($query) use ($post) {
            $query->whereBetween('hour_rate', [$post->min_price, $post->max_price]);
        })->whereHas('teachingCategories', function ($query) use ($post) {
            $query->where('category_id', $post->teaching_category);
        })->get();

        return $data;
    }
    public function categoryInstructor(array $payload)
    {
        $instructor_ids = $this->teachingCategory->where('category_id', gv($payload, 'category_id'))
            ->pluck('instructor_id')->toArray();
        return $this->user->whereIn('id', $instructor_ids)->get(['id', 'name']);
    }
    public function shareInstructorStore(array $payload)
    {
        if (auth()->check()) {
            $this->wishlist->updateOrCreate([
                'instructor_id' => gv($payload, 'instructor_id'),
                'user_id' => gv($payload, 'student_id'),
            ]);
        }
        $this->model->where('id', $payload['post_id'])->update(['status'=>0]);
        return true;
    }
}
