<?php

namespace Modules\Affiliate\Listeners;


use App\User;
use Browser;
use Carbon\Carbon;
use Modules\Affiliate\Entities\AffiliateCommission;
use Modules\Affiliate\Entities\AffiliateLink;
use Modules\Affiliate\Entities\AffiliateLinkVisitTrackUser;
use Modules\Affiliate\Entities\AffiliateReferralPayment;
use Modules\Affiliate\Events\ReferralPayment;
use Modules\BundleSubscription\Entities\BundleCoursePlan;
use Modules\CourseSetting\Entities\Course;
use Modules\Subscription\Entities\CourseSubscription;
use Request;


class ReferralPaymentListener
{

    public function handle(ReferralPayment $event)
    {
        $purchaseType =$event->type;
        $purchasePrice = $event->purchase_price;

        if ($purchasePrice<=0){
            return false;
        }

        $getAffiliateLink =$this->getAffiliateLink($event->topic_id);
         if (!$getAffiliateLink){
            return false;
        }

        $owner_id = $getAffiliateLink->owner_id;
        $affiliate_link_id = $getAffiliateLink->id;
        $type =$getAffiliateLink->type;


        $course_id =($purchaseType == 'course'?$event->topic_id:0);
        $bundle_id =($purchaseType == 'bundle'?$event->topic_id:0);
        $plan_id =($purchaseType == 'subscription'?$event->topic_id:0);



        $commission_amount=0;
        $commission_type='Percentage';

        if ($type=='course'){
            $specificCommission =AffiliateCommission::query()
                ->where('commable_type',Course::class)
                ->where('commable_id',$event->topic_id)
                ->where('commission_for','course')
                ->first();
            if ($specificCommission){
                $commission_type        =   $specificCommission->type==1?'Percentage':'Flat';
                $commission_amount      =   (float)$specificCommission->amount;
            }

        }elseif ($type=='bundle'){
            $specificCommission =AffiliateCommission::query()
                ->where('commable_type',BundleCoursePlan::class)
                ->where('commable_id',$event->topic_id)
                ->where('commission_for','bundle')
                ->first();
            if ($specificCommission){
                $commission_type    =$specificCommission->type==1?'Percentage':'Flat';
                $commission_amount    = (float)$specificCommission->amount;
            }
        }elseif ($type=='subscription'){
            $specificCommission =AffiliateCommission::query()
                ->where('commable_type',CourseSubscription::class)
                ->where('commable_id',$event->topic_id)
                ->where('commission_for','subscription')
                ->first();
            if ($specificCommission){
                $commission_type    =$specificCommission->type==1?'Percentage':'Flat';
                $commission_amount    = (float)$specificCommission->amount;
            }
        }elseif($type=='common'){
            if ($purchaseType=='course'){
                $commission_type =       affiliateConfig('commission_type');
                $commission_amount =   (float) affiliateConfig('commission_amount');
            }elseif ($purchaseType=='bundle'){
                $commission_type =affiliateConfig('commission_type');
                $commission_amount = (float)affiliateConfig('bundle_commission_amount');
            }elseif ($purchaseType=='subscription'){
                $commission_type =affiliateConfig('commission_type');
                $commission_amount = (float)affiliateConfig('plan_commission_amount');
            }
        }

        if($commission_amount != 0 && $commission_type == 'Percentage'){
            $amount =(float)  ($purchasePrice * $commission_amount) / 100;
        }else{
            $amount =(float) $commission_amount;
        }



        $user = User::with(['isReferralUser','isReferralUser.affiliateLink'])->find($event->user_id);

        $data = [
            'payment_to'=>$owner_id,
            'affiliate_link_id'=>$affiliate_link_id,
            'amount'=>number_format($amount,2),
            'payment_from'=>$user->id,
            'type'=>$type,
            'course_id'=> $course_id,
            'bundle_id'=> $bundle_id,
            'plan_id'=> $plan_id,
            'date'=>date('Y-m-d'),
        ];
         if(affiliateConfig('referral_duration_type') == 'Fixed'){
            $validity_end_date = Carbon::parse($user->isReferralUser->validity_start_date)->addDays(affiliateConfig('referral_duration'));
            $today = Carbon::now();
            if($today->lte($validity_end_date)){
                AffiliateReferralPayment::create($data);

            }
        }elseif(affiliateConfig('referral_duration_type') == 'Onetime'){
             $onetime_flag = $this->checkAffiliateLinkPaymentAvailable($data);
             if($onetime_flag){
                 AffiliateReferralPayment::create($data);
             }
        }else{
             AffiliateReferralPayment::create($data);
        }
    }

    private function getAffiliateLink($id)
    {
        $ip = Request::ip();
        $agent = Browser::browserFamily() . '-' . Browser::platformName() . '-' . Browser::deviceModel();
        $visitedLinkIds =AffiliateLinkVisitTrackUser::query()
            ->where('ip',$ip)
            ->where('agent',$agent)
            ->pluck('affiliate_link_id')->toArray();
        return AffiliateLink::whereIn('id',$visitedLinkIds)

            ->where(function ($query) use ($id) {
                $query->where('topic_id',$id)
                    ->orWhereNull('topic_id');
            })
            ->orderBy('topic_id','desc')->latest()->first();

    }

    private function checkAffiliateLinkPaymentAvailable($data)
    {
        $payment = AffiliateReferralPayment::where('affiliate_link_id',$data['affiliate_link_id'])->first();
        if($payment){
            return false;
        }else{
            return true;
        }
    }
}
