<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Modules\SystemSetting\Entities\EmailTemplate;

class AddMobileNotificaitonForOtp extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (Schema::hasTable('oauth_access_tokens')) {
            Schema::table('oauth_access_tokens', function (Blueprint $blueprint) {
                $blueprint->boolean('tfa')->default(0);
            });
        }else{
            return;
        }
        $template = EmailTemplate::where('act', 'Two_Factor_Authentication')->first();
        if ($template) {
            $template->browser_message = 'Your 2FA code is {{otp_code}}.';
            $template->save();
        }

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        //
    }
}
