<?php

namespace Modules\Subscription\Http\Controllers;

use Brian2694\Toastr\Facades\Toastr;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\Subscription\Entities\CourseSubscription;
use Modules\Subscription\Entities\PlanFeature;

class PlanFeatureController extends Controller
{

    public function index(Request $request)
    {
        try {
            $query = PlanFeature::query();
            $hasPlan = false;
            $id = 0;
            if (!empty($request->id)) {
                $query->where('plan_id', $request->id);
                $hasPlan = true;
                $id = $request->id;

            }
            $features = $query->orderBy('order', 'asc')->get();
            return view('subscription::feature.index', compact('features', 'id', 'hasPlan'));

        } catch (\Exception $e) {
            Toastr::error(trans('common.Operation failed'), trans('common.Failed'));
            return redirect()->back();

        }

    }

    public function store(Request $request)
    {
        if (demoCheck()) {
            return redirect()->back();
        }
        $request->validate([
            'title' => 'required',

        ]);

        try {
            $total = PlanFeature::latest()->count();
            $plan = new PlanFeature();
            $plan->title = $request->title;
            $plan->plan_id = (int)$request->plan;

            $plan->order = $total + 1;

            $plan->save();

            Toastr::success(trans('common.Operation successful'), trans('common.Success'));

            return redirect()->back();

        } catch (\Exception $e) {
            Toastr::error(trans('common.Operation failed'), trans('common.Failed'));

            return redirect()->back();
        }
    }


    public function update(Request $request)
    {
        if (demoCheck()) {
            return redirect()->back();
        }
        $request->validate([
            'title' => 'required|unique:course_subscriptions,title,' . $request->id,

        ]);

        try {
            $plan = PlanFeature::findOrFail($request->id);
            $plan->title = $request->title;
            $plan->order = $request->order;
            $plan->plan_id = (int)$request->plan;
            $plan->save();

            Toastr::success(trans('common.Operation successful'), trans('common.Success'));

            return redirect()->back();
        } catch (\Exception $e) {
            Toastr::error(trans('common.Operation failed'), trans('common.Failed'));
            return redirect()->back();
        }
    }

    public function destroy(Request $request)
    {
        if (demoCheck()) {
            return redirect()->back();
        }
        try {
            $id = (int)$request->id;
            $item = PlanFeature::findOrFail($id);
            $item->delete();
            Toastr::success(trans('common.Operation successful'), trans('common.Success'));

            return redirect()->back();

        } catch (\Exception $e) {
            Toastr::error(trans('common.Operation failed'), trans('common.Failed'));
            return redirect()->back();
        }
    }


    public function changePlanFeaturePosition(Request $request)
    {
        if (demoCheck()) {
            return false;
        }
        $ids = $request->get('ids');

        if (count($ids) != 0) {
            foreach ($ids as $key => $id) {

                $chapter = PlanFeature::find($id);
                if ($chapter) {
                    $chapter->order = $key + 1;
                    $chapter->save();
                }
            }
        }
        return true;
    }
}
