<?php

namespace Modules\Subscription\Entities;

use App\Traits\Tenantable;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\DB;

class SubscriptionSetting extends Model
{
    use Tenantable;

    protected $fillable = [];

    public static function boot()
    {
        parent::boot();
        self::created(function ($model) {
            Cache::forget('SubscriptionSetting_' . SaasDomain());
        });
        self::updated(function ($model) {
            Cache::forget('SubscriptionSetting_' . SaasDomain());
        });
        self::deleted(function ($model) {
            Cache::forget('SubscriptionSetting_' . SaasDomain());
        });
    }

    public static function getData()
    {
        return Cache::rememberForever('SubscriptionSetting_' . SaasDomain(), function () {
            $setting = DB::table('subscription_settings')->where('lms_id', SaasInstitute()->id)->first();
            if (!$setting) {
                $setting = DB::table('subscription_settings')->first();
            }
            return $setting;
        });
    }
}
