<?php

namespace Modules\Subscription\Entities;

use App\Traits\Tenantable;
use App\User;
use Illuminate\Database\Eloquent\Model;

class SubscriptionCourse extends Model
{
    use Tenantable;

    protected $fillable = [];

    public function checkout()
    {
        return $this->belongsTo(SubscriptionCheckout::class, 'checkout_id')->withDefault();
    }

    public function instructor()
    {
        return $this->belongsTo(User::class, 'user_id')->withDefault();
    }
}
