@extends('backend.master')


@php
    $table_name = 'product_carriers';
@endphp
@section('table')
    {{ $table_name }}
@endsection

@section('mainContent')

    @php
        $LanguageList = getLanguageList();
    @endphp

    {!! generateBreadcrumb() !!}

    <section class="admin-visitor-area up_st_admin_visitor">
        <div class="container-fluid p-0">
            <div class="row">
                <div class="col-lg-3">

                    <div class="white-box mb_30  student-details header-menu">
                        <div class="box_header common_table_header">
                            <div class="main-title d-md-flex mb-0">
                                <h3 class="mb-0" id="">
                                    {{ @$data['title'] }}
                                </h3>
                                @if (isset($edit))
                                    @if (permissionCheck('store.carrier.index'))
                                        <a href="{{ route('store.carrier.index') }}"
                                           class="primary-btn small fix-gr-bg ms-4"
                                           style="line-height: 25px;" title="{{ __('courses.Add New') }}">+</a>
                                    @endif
                                @endif
                            </div>
                        </div>

                        @if (isset($data['show']))
                            <form action="{{ route('store.carrier.update') }}" method="POST" id="category-form"
                                  name="category-form" enctype="multipart/form-data">
                                <input type="hidden" name="id" value="{{ $data['show']->id }}">
                                @else

                                    <form action="{{ route('store.carrier.store') }}" method="POST" id="category-form"
                                          name="category-form" enctype="multipart/form-data">

                                        @endif
                                        @csrf

                                        <div class="row">
                                            <div class="col-xl-12">
                                                <div class="primary_input mb-25">
                                                    <label class="primary_input_label"
                                                           for="nameInput">{{ __('common.Name') }}
                                                        <strong class="text-danger">*</strong></label>
                                                    <input name="name" id="nameInput"
                                                           class="primary_input_field name {{ @$errors->has('name') ? ' is-invalid' : '' }}"
                                                           placeholder="{{ __('common.Name') }}" type="text"
                                                           value="{{ isset($data['show']) ? $data['show']->name : old('name') }}">


                                                </div>

                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-xl-12">
                                                <div class="primary_input mb-25">
                                                    <label class="primary_input_label"
                                                           for="tracking_urlInput">{{ _trans('store.Traking Url') }}
                                                    </label>
                                                    <input name="tracking_url" id="tracking_urlInput"
                                                           class="primary_input_field tracking_url {{ @$errors->has('tracking_url') ? ' is-invalid' : '' }}"
                                                           placeholder="{{ _trans('store.Traking Url') }}" type="text"
                                                           value="{{ isset($data['show']) ? $data['show']->tracking_url : old('tracking_url') }}">

                                                    @if ($errors->has('tracking_url'))
                                                        <span class="invalid-feedback d-block mb-10" role="alert">
                                            <strong>{{ @$errors->first('tracking_url') }}</strong>
                                        </span>
                                                    @endif

                                                </div>

                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-xl-12">
                                                <div class="primary_input mb-25">
                                                    <label class="primary_input_label"
                                                           for="status">{{ __('courses.Status') }}</label>
                                                    <select class="primary_select mb-25" name="status" id="status">
                                                        <option value="1"
                                                            {{ isset($data['show']) ? ($data['show']->status == 1 ? 'selected' : '') : '' }}>
                                                            {{ __('common.Active') }}</option>
                                                        <option value="0"
                                                            {{ isset($data['show']) ? ($data['show']->status == 0 ? 'selected' : '') : '' }}>
                                                            {{ __('common.Inactive') }}</option>
                                                    </select>
                                                </div>
                                            </div>

                                            <div class="col-lg-12 mt-10">
                                                <div class="  mb-15">
                                                    <x-upload-file name="logo" type="image"
                                                                   media_id="{{ isset($data['show']) ? $data['show']->logo_media?->media_id : '' }}"
                                                                   label="{{ _trans('common.Logo') }}"
                                                                   note="{{ __('student.Recommended size') }} ({{translatedNumber('300x300')}})"/>


                                                </div>
                                            </div>

                                            <div class="col-lg-12 text-center">
                                                <div class="d-flex justify-content-center pt_20">
                                                    <button type="submit" class="primary-btn semi_large fix-gr-bg"
                                                            id="save_button_parent">
                                                        <i class=" fa fa-check "></i>
                                                        @if (!isset($data['show']))
                                                            {{ __('common.Save') }}
                                                        @else
                                                            {{ __('common.Update') }}
                                                        @endif
                                                    </button>


                                                </div>
                                            </div>
                                        </div>

                                    </form>
                    </div>


                </div>
                <div class="col-lg-9">
                    <div class="white-box">
                        <div class="box_header common_table_header">
                            <div class="main-title d-md-flex mb-0">
                                <h3 class="mb-0" id="page_title">{{ _trans('store.Carriers List') }}</h3>
                            </div>
                        </div>
                        <div class="  QA_section QA_section_heading_custom check_box_table">
                            <div class="QA_table ">
                                <div class="">
                                    <table id="lms_table" class="table table-data">
                                        <thead>
                                        <tr>
                                            <th scope="col">{{ __('common.SL') }}</th>
                                            <th scope="col">{{ __('common.Name') }}</th>
                                            <th scope="col">{{ __('common.Status') }}</th>
                                            <th scope="col">{{ __('common.Action') }}</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        @foreach ($data['carriers'] as $key => $carrier)
                                            <tr>
                                                <td>{{ translatedNumber(++$key) }}</td>
                                                <td> {{ @$carrier->name }}</td>


                                                <td class="nowrap">
                                                    <x-backend.status :id="$carrier->id" :status="$carrier->status"
                                                                      :route="'store.author.status'">
                                                    </x-backend.status>

                                                </td>

                                                <td>
                                                    <div class="dropdown CRM_dropdown">
                                                        <button class="btn btn-secondary dropdown-toggle" type="button"
                                                                id="dropdownMenu1{{ @$carrier->id }}"
                                                                data-bs-toggle="dropdown"
                                                                aria-haspopup="true" aria-expanded="false">
                                                            {{ __('common.Select') }}
                                                        </button>
                                                        <div class="dropdown-menu dropdown-menu-right"
                                                             aria-labelledby="dropdownMenu1{{ @$carrier->id }}">

                                                            <a class="dropdown-item edit_brand"
                                                               href="{{ route('store.carrier.edit', $carrier->id) }}">{{ __('common.Edit') }}</a>

                                                            <a onclick="confirm_modal('{{ route('store.carrier.destroy', $carrier->id) }}');"
                                                               class="dropdown-item edit_brand">{{ __('common.Delete') }}</a>

                                                        </div>
                                                    </div>
                                                </td>
                                            </tr>
                                        @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>


    @include('store::partials.delete_modal')

@endsection


@push('scripts')
    <script type="application/javascript">
        (function ($) {
            "use strict";

            dataTableOptions = updateColumnExportOption(dataTableOptions, [0, 1,]);

            $('#lms_table').DataTable(dataTableOptions);
        })(jQuery);


    </script>
@endpush
