@extends('backend.master')


@php
    $table_name='products';
@endphp

@section('mainContent')
    {!! generateBreadcrumb() !!}
    <div id="add_product">
        <section class="admin-visitor-area up_st_admin_visitor">
            <div class="container-fluid p-0">
                <div class="row justify-content-center">
                    <div class="col-12">
                        <div class="white-box">
                            <div class="box_header">
                                <div class="main-title d-flex flex-wrap gap-3 justify-content-between w-100">
                                    <h3 class="mb-0 mr-30">{{ __('product.Bulk Product Upload') }}</h3>
                                    <div class="">
                                        <a href="{{ route('exportSampleProduct') }}"
                                           class="primary-btn small fix-gr-bg float-end">
                                            <span class="fas fa-download pe-2"></span>
                                            {{ __('product.Sample File Download') }}
                                        </a>
                                    </div>
                                </div>
                            </div>
                            <form action="{{ route('product.bulk_product_store') }}" method="POST"
                                  enctype="multipart/form-data" class="csvForm">
                                @csrf
                                <div class="row form">
                                    <div class="col-xl-12 col-lg-12 col-md-12">
                                        <div class="primary_input mb-15">
                                            <label class="primary_input_label"
                                                   for="">{{ __('product.Excel Upload') }} <span
                                                    class="required_mark">*</span> </label>
                                            <div class="primary_file_uploader">
                                                <input class="primary-input" type="text" id="placeholderFileOneName"
                                                       placeholder="{{ __('product.Browse File') }}" readonly="">
                                                <button class="" type="button">
                                                    <label class="primary-btn small fix-gr-bg"
                                                           for="document_file_1">{{__("product.Browse")}} </label>
                                                    <input type="file" class="d-none" accept=".xlsx, .xls"
                                                           name="excel_file" id="document_file_1">
                                                </button>
                                            </div>
                                            <span class="red">{{$errors->first('file')}}</span>
                                        </div>
                                    </div>
                                    <div class="col-xl-12 col-lg-12 col-md-12">
                                        <div class="primary_input mb-15">
                                            <label class="primary_input_label red_text"
                                                   for="">{{ __('product.Download Warning') }}</label>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-12">
                                    <div class="d-flex justify-content-center pt_20">
                                        <button type="submit"
                                                class="primary-btn semi_large csvFormBtn fix-gr-bg"
                                                data-bs-toggle="tooltip"
                                                id="save_button_parent">
                                            <i class="ti-check"></i>
                                            {{__('common.Import')}}
                                        </button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
@endsection
