@extends('backend.master')


@php
    $table_name = 'product_orders';
@endphp
@section('table')
    {{ $table_name }}
@endsection

@section('mainContent')

    @php
        $LanguageList = getLanguageList();
    @endphp

    {!! generateBreadcrumb() !!}

    <section class="admin-visitor-area up_st_admin_visitor">
        <div class="container-fluid p-0">
            <div class="row">
                <div class="col-lg-12">
                    <div class="box_header common_table_header">
                        <div class="main-title d-md-flex mb-0">
                            <h3 class="mb-0">{{ @ $data['title'] }}</h3>
                        </div>
                    </div>
                    <div class="  QA_section QA_section_heading_custom check_box_table">
                        <div class="QA_table ">
                            <div class="">
                                <table id="lms_table" class="table table-data">
                                    <thead>
                                    <tr>
                                        <th scope="col">{{ __('common.SL') }}</th>
                                        <th scope="col">{{ _trans('store.Order ID') }}</th>
                                        <th scope="col">{{ _trans('store.Customer') }}</th>
                                        <th scope="col">{{ _trans('store.Seller') }}
                                            /{{ _trans('store.Instructor') }}</th>
                                        <th scope="col">{{ _trans('store.Quantity') }}</th>
                                        <th scope="col">{{ _trans('store.Total Amount') }}</th>
                                        <th scope="col">{{ _trans('store.Discount') }}</th>
                                        <th scope="col">{{ _trans('store.Net Amount') }}</th>
                                        <th scope="col">{{ _trans('store.Order Date') }}</th>
                                        <th scope="col">{{ _trans('store.Order Status') }}</th>
                                        <th scope="col">{{ __('common.Action') }}</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @foreach ($data['orders'] as $key => $order)
                                        <tr>
                                            <td>{{ ++$key }}</td>
                                            <td>{{ @$order->order_id }}</td>
                                            <td>{{ @$order->customer->name }}</td>
                                            <td>{{ @$order->product->user->name }}</td>
                                            <td>{{ @$order->quantity }}</td>
                                            <td>{{ @$order->total_price }}</td>
                                            <td>{{ @$order->discount_amount }}</td>
                                            <td>{{ @$order->net_price }}</td>
                                            <td>{{ @$order->order_date }}</td>
                                            <td>{{ @$order->order_status }}</td>
                                            <td>
                                                <div class="dropdown CRM_dropdown">
                                                    <button class="btn btn-secondary dropdown-toggle" type="button"
                                                            id="dropdownMenu1{{ @$order->id }}"
                                                            data-bs-toggle="dropdown" aria-haspopup="true"
                                                            aria-expanded="false">
                                                        {{ __('common.Select') }}
                                                    </button>
                                                    <div class="dropdown-menu dropdown-menu-right"
                                                         aria-labelledby="dropdownMenu1{{ @$order->id }}">
                                                        @if (permissionCheck('store.publication.edit'))
                                                            <a class="dropdown-item edit_brand"
                                                               href="{{ route('store.publication.edit', $order->id) }}">{{ __('common.Edit') }}</a>
                                                        @endif
                                                        @if (permissionCheck('store.publication.destroy'))
                                                            <a onclick="confirm_modal('{{ route('store.publication.destroy', $order->id) }}');"
                                                               class="dropdown-item edit_brand">{{ __('common.Delete') }}</a>
                                                        @endif
                                                    </div>
                                                </div>
                                            </td>
                                        </tr>
                                    @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>


    @include('store::partials.delete_modal')

@endsection


@push('scripts')
    <script src="{{ asset('/') }}/Modules/Store/Resources/assets/js/category.js"></script>
@endpush
