@extends('backend.master')


@php
    $table_name = 'product_brands';
@endphp
@section('table')
    {{ $table_name }}
@endsection

@section('mainContent')

    @php
        $LanguageList = getLanguageList();
    @endphp

    {!! generateBreadcrumb() !!}

    <section class="admin-visitor-area up_st_admin_visitor">
        <div class="container-fluid p-0">
            <div class="white-box">

                <div class="row">
                    <div class="col-lg-12">
                        <div class="box_header common_table_header">
                            <div class="main-title d-md-flex mb-0">
                                <h3 class="mb-0 mr-30 mb_xs_15px mb_sm_20px"
                                    id="page_title">{{ __('product.Brand List') }}</h3>

                                @if (permissionCheck('store.attribute.store'))
                                    <li><a class="primary-btn radius_30px   fix-gr-bg"
                                           id="add_student_btn" href="{{route('store.brand.create')}} "><i
                                                class="ti-plus"></i>{{__('product.Add New Brand')}}</a>
                                    </li>
                                @endif
                            </div>
                        </div>
                        <div class="  QA_section QA_section_heading_custom check_box_table">
                            <div class="QA_table ">
                                <div class="">
                                    <table id="lms_table" class="table table-data">
                                        <thead>
                                        <tr>
                                            <th scope="col">{{ __('common.SL') }}</th>
                                            <th scope="col">{{ __('common.Name') }}</th>
                                            <th scope="col">{{ __('common.Logo') }}</th>
                                            <th scope="col">{{ __('common.Status') }}</th>
                                            <th scope="col">{{ __('common.Action') }}</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        @foreach ($brands as $key => $brand)
                                            <tr>
                                                <td>{{ translatedNumber(++$key) }}</td>
                                                <td> {{ checkParent($brand) }} {{ @$brand->name }}</td>
                                                <td>
                                                    <div>
                                                        <img style="width: 70px !important;"
                                                             src="@if (isset($brand->logo)) {{ url(@$brand->logo) }} @endif"
                                                             alt="" class="img img-responsive m-2">
                                                    </div>
                                                </td>


                                                <td class="nowrap">
                                                    <x-backend.status :id="$brand->id" :status="$brand->status"
                                                                      :route="'store.brand.status'">
                                                    </x-backend.status>

                                                </td>

                                                <td>
                                                    <div class="dropdown CRM_dropdown">
                                                        <button class="btn btn-secondary dropdown-toggle" type="button"
                                                                id="dropdownMenu1{{ @$brand->id }}"
                                                                data-bs-toggle="dropdown"
                                                                aria-haspopup="true" aria-expanded="false">
                                                            {{ __('common.Select') }}
                                                        </button>
                                                        <div class="dropdown-menu dropdown-menu-right"
                                                             aria-labelledby="dropdownMenu1{{ @$brand->id }}">
                                                            @if (permissionCheck('store.brand.edit'))
                                                                <a class="dropdown-item edit_brand"
                                                                   href="{{ route('store.brand.edit', $brand->id) }}">{{ __('common.Edit') }}</a>
                                                            @endif
                                                            @if (permissionCheck('store.brand.destroy'))
                                                                <a onclick="confirm_modal('{{ route('store.brand.destroy', $brand->id) }}');"
                                                                   class="dropdown-item edit_brand">{{ __('common.Delete') }}</a>
                                                            @endif
                                                        </div>
                                                    </div>
                                                </td>
                                            </tr>
                                        @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>


    @include('store::partials.delete_modal')

@endsection

@push('scripts')
    <script type="application/javascript">
        (function ($) {
            "use strict";
            dataTableOptions = updateColumnExportOption(dataTableOptions, [0, 1]);

            $('#lms_table').DataTable(dataTableOptions);

        })(jQuery);
    </script>
@endpush
