<?php

namespace Modules\Store\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class RefundProcessRequest extends FormRequest
{
    public function rules()
    {
        return [
            'name' => 'required|max:255|unique:refund_processes,name,' . $this->id,
            'description' => 'required'
        ];
    }

    public function messages()
    {

        return [
            'name.required' => 'The name field is required',
            'name.*.unique' => 'The name field is already be taken',
            'description.required' => 'The description field is required',
        ];

    }

    public function authorize()
    {
        return true;
    }
}
