<?php

namespace Modules\Store\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class PublicationRequest extends FormRequest
{
    public function rules()
    {
        $code = auth()->user()->language_code;
        if (isModuleActive('FrontendMultiLang')) {
            return [
                'name.' . $code => [
                    'required',
                ]
            ];
        } else {
            return [
                'name.' . $code => [
                    'required',
                ]
            ];
        }
    }

    public function messages()
    {
        if (isModuleActive('FrontendMultiLang')) {
            return validationMessage([
                'name.*.required' => 'The Publication name is required',
            ]);
        } else {
            return validationMessage([
                'name.required' => 'The Publication name is required',
            ]);
        }
    }


    public function authorize()
    {
        return true;
    }
}
