<?php

namespace Modules\Store\Http\Controllers;

use Brian2694\Toastr\Facades\Toastr;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\Store\Http\Requests\CreateShippingRequest;
use Modules\Store\Http\Requests\UpdateShippingRequest;
use Modules\Store\Repositories\CarrierRepository;
use Modules\Store\Repositories\ShippingRepository;

class RateController extends Controller
{
    protected $shippingRepository;
    protected $carrierRepo;

    public function __construct(ShippingRepository $shippingRepository, CarrierRepository $carrierRepo)
    {
        $this->shippingRepository = $shippingRepository;
        $this->carrierRepo = $carrierRepo;
    }

    public function index()
    {
        try {
            $data['methods'] = $this->shippingRepository->getAll();
            $data['carriers'] = $this->carrierRepo->getActiveAll();
            return view('store::shipping.shipping_methods.index', compact('data'));
        } catch (\Throwable $th) {
            Toastr::error(trans('common.Operation failed'), trans('common.Failed'));
            return redirect()->back();
        }
    }

    public function store(CreateShippingRequest $request)
    {
        try {
            $shipping_methods = $this->shippingRepository->store($request->except("_token"));
            if ($shipping_methods) {
                Toastr::success(trans('common.Operation successful'), trans('common.Success'));
                return redirect()->back();
            } else {
                Toastr::error(trans('common.Operation failed'), trans('common.Failed'));
                return redirect()->back();
            }
        } catch (\Exception $e) {
            Toastr::error(trans('common.Operation failed'), trans('common.Failed'));
            return redirect()->back();
        }
    }

    public function edit($id)
    {


        try {
            $data['methods'] = $this->shippingRepository->getAll();
            $data['show'] = $this->shippingRepository->findById($id);
            $data['carriers'] = $this->carrierRepo->getActiveAll();
            if (auth()->user()->role->slug == 'seller' && $data['show']->request_by_user != auth()->user()->id) {
                Toastr::error(__('common.Something Went Wrong'));
                return false;
            }
            return view('store::shipping.shipping_methods.index', compact('data'));
        } catch (\Throwable $th) {
            Toastr::error(trans('common.Operation failed'), trans('common.Failed'));
            return redirect()->back();
        }
    }

    public function update(UpdateShippingRequest $request)
    {
        try {
            $shipping_methods = $this->shippingRepository->update($request->except("_token"));
            if ($shipping_methods) {
                Toastr::success(trans('common.Operation successful'), trans('common.Success'));
                return redirect()->route('store.shiprate.index');
            } else {
                Toastr::error(trans('common.Operation failed'), trans('common.Failed'));
                return redirect()->back();
            }
        } catch (\Exception $e) {
            Toastr::error(trans('common.Operation failed'), trans('common.Failed'));
            return redirect()->back();
        }
    }


    public function destroy(Request $request)
    {
        try {
            $result = $this->shippingRepository->delete($request->id);
            if ($result == "invalid") {
                $msg = _trans('store.Invalid Request.');
            } elseif ($result == "not_possible") {
                $msg = _trans('common.related_data_exist_in_multiple_directory');
            } elseif ($result == "not_possible_for_1") {
                $msg = _trans('store.Last Shipping Rate Is Not Deletable.');
            } else {
                $msg = 'success';
            }

            if ($msg == 'success') {
                Toastr::success(trans('common.Operation successful'), trans('common.Success'));
            } else {
                Toastr::error(trans('common.Operation failed'), trans('common.Failed'));
            }
            return redirect()->route('store.shiprate.index');
        } catch (\Exception $e) {
            Toastr::error(trans('common.Operation failed'), trans('common.Failed'));
            return redirect()->back();
        }
    }


    public function update_status(Request $request)
    {
        try {
            $result = $this->shippingRepository->updateStatus($request->except("_token"));
            if ($result == 'last shipping rate disable not posible') {
                return response()->json([
                    'status' => 'last shipping rate disable not posible'
                ]);
            }
            return response()->json([
                'status' => 1
            ]);
        } catch (\Exception $e) {
            return 0;
        }
    }

    public function update_approve_status(Request $request)
    {
        try {
            $this->shippingRepository->updateApproveStatus($request->except("_token"));
            return 1;
        } catch (\Exception $e) {
            return 0;
        }
    }


    private function reloadWithData()
    {
        try {
            $carrierRepo = new CarrierRepository();
            $carriers = $carrierRepo->getActiveAll();
            $methods = $this->shippingRepository->getAll();
            return response()->json([

                'TableData' => (string)view('shipping::shipping_methods.components._method_list', compact('methods', 'carriers')),
                'createForm' => (string)view('shipping::shipping_methods.components._create', compact('carriers'))
            ], 200);
        } catch (\Exception $e) {
            Toastr::error($e->getMessage(), 'Error!!');
            return response()->json([
                'error' => $e->getMessage()
            ], 503);
        }
    }
}
