<?php

namespace Modules\Store\Exports\DropDownSheets;

use Maatwebsite\Excel\Concerns\FromQuery;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Concerns\WithTitle;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Events\AfterSheet;
use Modules\Store\Entities\ProductBrand;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;

class BrandList implements FromQuery, WithTitle, WithMapping, WithEvents
{


    public function query()
    {
        return ProductBrand::query()
            ->where('status', 1)
            ->orderBy('sort_id');
    }

    /**
     * @return string
     */
    public function title(): string
    {
        return 'product_brands';
    }


    public function map($product_brand): array
    {
        return [
            $product_brand->name
        ];
    }

    public function registerEvents(): array
    {
        return [
            AfterSheet::class => function (AfterSheet $event) {
                $event->sheet->setSheetState(Worksheet::SHEETSTATE_HIDDEN);
            },
        ];
    }
}
