<?php

namespace Modules\Store\Database\Seeders;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Seeder;
use Modules\CourseSetting\Entities\Course;
use Modules\Store\Entities\Product;
use Modules\Store\Entities\ProductBrand;
use Modules\Store\Entities\ProductCategory;
use Modules\Store\Http\Controllers\StoreOrderResetController;

class StoreDatabaseSeeder extends Seeder
{
    public function run()
    {
        Model::unguard();

        ProductCategory::insert([
            [
                'title' => 'E-Books',
                'user_id' => 1,
                'position_order' => 1
            ],
            [
                'title' => 'Physical Book',
                'user_id' => 1,
                'position_order' => 2
            ],[
                'title' => 'Physical Items',
                'user_id' => 1,
                'position_order' => 3
            ],
            [
                'title' => 'Fiction',
                'user_id' => 1,
                'position_order' => 4
            ],
            [
                'title' => 'Non-Fiction',
                'user_id' => 1,
                'position_order' => 5
            ],
            [
                'title' => 'Science',
                'user_id' => 1,
                'position_order' => 6
            ],
            [
                'title' => 'Technology',
                'user_id' => 1,
                'position_order' => 7
            ],
            [
                'title' => 'Art',
                'user_id' => 1,
                'position_order' => 8
            ],
        ]);

        ProductBrand::insert([
            [
                'name' => 'Penguin Random House',
                'created_by' => 1,
            ],
            [
                'name' => 'HarperCollins',
                'created_by' => 1,
            ],
            [
                'name' => 'Simon & Schuster',
                'created_by' => 1,
            ],
            [
                'name' => 'Macmillan Publishers',
                'created_by' => 1,
            ],
            [
                'name' => 'Hachette Livre',
                'created_by' => 1,
            ],
        ]);



        $products = [
            [
                'user_id' => 1,
                'title' => 'Introduction to Web Design',
                'description' => '<p>Introduction to Web Design is an extensive guide for beginners who wish to grasp the essentials of creating beautiful and functional websites. Covering HTML, CSS, and modern web development techniques, this e-book takes a practical approach with hands-on examples and real-world projects.</p><p>You’ll learn how to structure web pages, style them with CSS, and implement interactive elements using JavaScript. It’s a perfect guide for anyone aspiring to become a web developer or enhance their design skills.</p>',
                'category_id' => 1,
                'brand_id' => rand(1, 5),
                'price' => rand(50, 200),
                'stock_manage' => 0,
                'stock_quantity' => 0,
                'is_readable' => 1,
                'soft_file' => 'Modules/Store/Resources/assets/files/sample.pdf',
                'type' => 1,
                'image' => 'public/frontend/infixlmstheme/img/product/1.jpg',
                'thumbnail' => 'public/frontend/infixlmstheme/img/product/1.jpg',
            ],
            [
                'user_id' => 1,
                'title' => 'Learn Python Programming',
                'description' => '<p>Learn Python Programming is a comprehensive resource designed to help you master Python, a versatile and popular programming language. The book begins with the basics, such as syntax, loops, and functions, gradually introducing more advanced concepts like object-oriented programming and algorithms.</p><p>Through practical coding exercises, you will develop the skills needed to build your own applications, automate tasks, and work with data. Each chapter is structured to reinforce learning with real-world examples and projects.</p>',
                'category_id' => 1,
                'brand_id' => rand(1, 5),
                'price' => rand(50, 200),
                'stock_manage' => 0,
                'stock_quantity' => 0,
                'is_readable' => 1,
                'soft_file' => 'Modules/Store/Resources/assets/files/sample.pdf',
                'type' => 1,
                'image' => 'public/frontend/infixlmstheme/img/product/2.jpg',
                'thumbnail' => 'public/frontend/infixlmstheme/img/product/2.jpg',
            ],
            [
                'user_id' => 1,
                'title' => 'The Art of Software Development',
                'description' => '<p>The Art of Software Development is a must-read for anyone serious about building high-quality, maintainable software. This book covers essential topics such as software design patterns, agile methodologies, testing, and best coding practices that will help you become a better software engineer.</p><p>It dives into the intricacies of creating scalable software architectures that can handle real-world problems, making it a valuable resource for professional developers and students alike. Examples from industry-leading projects offer insight into how successful software products are built and maintained.</p>',
                'category_id' => 2,
                'brand_id' => rand(1, 5),
                'price' => rand(50, 200),
                'stock_manage' => 0,
                'stock_quantity' => 0,
                'is_readable' => 0,
                'type' => 2,
                'image' => 'public/frontend/infixlmstheme/img/product/3.jpg',
                'thumbnail' => 'public/frontend/infixlmstheme/img/product/3.jpg',
            ],
            [
                'user_id' => 1,
                'title' => 'The World of Data Science',
                'description' => '<p>The World of Data Science offers an in-depth exploration of the data-driven world we live in today. This book breaks down complex topics like big data, machine learning, and artificial intelligence in an easy-to-understand manner, making it accessible for anyone interested in entering the field.</p><p>Through engaging examples and case studies, you’ll learn how to process and analyze large datasets, build predictive models, and apply machine learning techniques to real-world problems. This book is perfect for data enthusiasts, analysts, and professionals looking to expand their knowledge.</p>',
                'category_id' => 2,
                'brand_id' => rand(1, 5),
                'price' => rand(50, 200),
                'stock_manage' => 0,
                'stock_quantity' => 0,
                'is_readable' => 0,
                'type' => 2,
                'image' => 'public/frontend/infixlmstheme/img/product/4.jpg',
                'thumbnail' => 'public/frontend/infixlmstheme/img/product/4.jpg',
            ],
            [
                'user_id' => 1,
                'title' => 'Adjustable Laptop Stand',
                'description' => '<p>Adjustable Laptop Stand is a perfect solution for anyone looking to improve their workstation ergonomics. Designed to reduce strain on your neck and back, this stand allows you to position your laptop at eye level, improving your posture and overall comfort while working.</p><p>Made from lightweight and durable materials, it is easy to carry, making it a great companion for people who work from multiple locations. The adjustable height feature lets you customize it according to your preferences, ensuring the perfect angle every time.</p>',
                'category_id' => 3,
                'brand_id' => rand(1, 5),
                'price' => rand(50, 200),
                'stock_manage' => 0,
                'stock_quantity' => 0,
                'is_readable' => 0,
                'type' => 2,
                'image' => 'public/frontend/infixlmstheme/img/product/5.jpg',
                'thumbnail' => 'public/frontend/infixlmstheme/img/product/5.jpg',
            ],
            [
                'user_id' => 1,
                'title' => 'Noise-Cancelling Headphones',
                'description' => '<p>Noise-Cancelling Headphones are designed to create an immersive audio experience by eliminating background noise, allowing you to focus on your work or enjoy your music without distractions. These headphones offer crystal-clear sound quality, making them perfect for both professional and personal use.</p><p>The soft, cushioned ear cups provide comfort for extended wear, while the adjustable headband ensures a snug fit. With superior noise cancellation technology, you can tune out the world and immerse yourself in your audio environment.</p>',
                'category_id' => 3,
                'brand_id' => rand(1, 5),
                'price' => rand(50, 200),
                'stock_manage' => 0,
                'stock_quantity' => 0,
                'is_readable' => 0,
                'type' => 2,
                'image' => 'public/frontend/infixlmstheme/img/product/6.jpg',
                'thumbnail' => 'public/frontend/infixlmstheme/img/product/6.jpg',
            ],
            [
                'user_id' => 1,
                'title' => 'The Time Traveler’s Journey',
                'description' => '<p>The Time Traveler’s Journey is a riveting science fiction novel that follows the adventures of a protagonist who has the ability to travel through time. As they journey through different eras, they uncover mysteries about the universe, face unforeseen challenges, and navigate through a complex web of events that will keep you on the edge of your seat.</p><p>The narrative blends suspense, drama, and imagination, offering a fresh take on the time-travel genre. With twists and turns at every corner, this book promises to keep readers engaged from start to finish.</p>',
                'category_id' => 4,
                'brand_id' => rand(1, 5),
                'price' => rand(50, 200),
                'stock_manage' => 0,
                'stock_quantity' => 0,
                'is_readable' => 0,
                'type' => 1,
                'image' => 'public/frontend/infixlmstheme/img/product/7.jpg',
                'thumbnail' => 'public/frontend/infixlmstheme/img/product/7.jpg',
            ],
            [
                'user_id' => 1,
                'title' => 'Mysteries of the Lost City',
                'description' => '<p>Mysteries of the Lost City is an engrossing mystery novel that immerses readers in the world of ancient civilizations. When a group of explorers stumbles upon the ruins of a long-lost city, they embark on a quest to unravel its secrets. Along the way, they face unexpected dangers, intricate puzzles, and surprising revelations.</p><p>With vivid descriptions and a gripping storyline, this novel keeps you guessing as new clues are revealed, leading to an unexpected conclusion. The richly developed characters and historical backdrop add depth to the tale, making it a compelling read for mystery lovers.</p>',
                'category_id' => 4,
                'brand_id' => rand(1, 5),
                'price' => rand(50, 200),
                'stock_manage' => 0,
                'stock_quantity' => 0,
                'is_readable' => 0,
                'type' => 1,
                'image' => 'public/frontend/infixlmstheme/img/product/8.jpg',
                'thumbnail' => 'public/frontend/infixlmstheme/img/product/8.jpg',
            ],
            [
                'user_id' => 1,
                'title' => 'A Brief History of the Internet',
                'description' => '<p>A Brief History of the Internet provides a comprehensive overview of the evolution of the internet, from its early beginnings to its current state. This book delves into the technological advancements, key figures, and major milestones that have shaped the digital world we live in today.</p><p>Written in an accessible style, it covers the development of web protocols, the rise of social media, and the impact of internet technology on modern society. It’s an informative read for anyone interested in understanding the internet’s journey and its future directions.</p>',
                'category_id' => 5,
                'brand_id' => rand(1, 5),
                'price' => rand(50, 200),
                'stock_manage' => 0,
                'stock_quantity' => 0,
                'is_readable' => 1,
                'soft_file' => 'Modules/Store/Resources/assets/files/sample.pdf',
                'type' => 1,
                'image' => 'public/frontend/infixlmstheme/img/product/9.jpg',
                'thumbnail' => 'public/frontend/infixlmstheme/img/product/9.jpg',
            ],
            [
                'user_id' => 1,
                'title' => 'Innovations in Renewable Energy',
                'description' => '<p>Innovations in Renewable Energy explores the latest advancements in sustainable energy technologies. This book covers various renewable energy sources, such as solar, wind, and hydro power, and examines cutting-edge research and applications that are driving the transition to cleaner energy solutions.</p><p>It provides insights into new technologies, industry trends, and the challenges facing the renewable energy sector. Ideal for students, professionals, and anyone interested in the future of energy, this book highlights how innovative solutions are shaping a more sustainable world.</p>',
                'category_id' => 5,
                'brand_id' => rand(1, 5),
                'price' => rand(50, 200),
                'stock_manage' => 0,
                'stock_quantity' => 0,
                'is_readable' => 1,
                'soft_file' => 'Modules/Store/Resources/assets/files/sample.pdf',
                'type' => 1,
                'image' => 'public/frontend/infixlmstheme/img/product/10.jpg',
                'thumbnail' => 'public/frontend/infixlmstheme/img/product/10.jpg',
            ],
            [
                'user_id' => 1,
                'title' => 'Art of the Renaissance',
                'description' => '<p>Art of the Renaissance offers an in-depth exploration of one of the most influential art movements in history. The book provides detailed analyses of key artworks, artists, and the cultural context that defined the Renaissance period. It covers masterpieces from renowned artists like Leonardo da Vinci, Michelangelo, and Raphael.</p><p>Richly illustrated and thoroughly researched, this book is an invaluable resource for art enthusiasts, students, and scholars. It brings to life the artistry and innovation of the Renaissance, showcasing the era’s enduring impact on the world of art.</p>',
                'category_id' => 6,
                'brand_id' => rand(1, 5),
                'price' => rand(50, 200),
                'stock_manage' => 0,
                'stock_quantity' => 0,
                'is_readable' => 0,
                'type' => 1,
                'image' => 'public/frontend/infixlmstheme/img/product/11.jpg',
                'thumbnail' => 'public/frontend/infixlmstheme/img/product/11.jpg',
            ],
            [
                'user_id' => 1,
                'title' => 'Modern Art Movements',
                'description' => '<p>Modern Art Movements explores the evolution of art from the late 19th century to the present. The book delves into various movements such as Impressionism, Cubism, Abstract Expressionism, and Pop Art, analyzing their influences, key artists, and defining characteristics.</p><p>With its engaging narrative and numerous illustrations, this book provides readers with a comprehensive understanding of modern art and its significance in contemporary culture. It’s an essential read for those interested in the dynamic world of modern art.</p>',
                'category_id' => 6,
                'brand_id' => rand(1, 5),
                'price' => rand(50, 200),
                'stock_manage' => 0,
                'stock_quantity' => 0,
                'is_readable' => 0,
                'type' => 1,
                'image' => 'public/frontend/infixlmstheme/img/product/12.jpg',
                'thumbnail' => 'public/frontend/infixlmstheme/img/product/12.jpg',
            ],
            [
                'user_id' => 1,
                'title' => 'Deep Learning for Beginners',
                'description' => '<p>Deep Learning for Beginners provides an introduction to one of the most exciting areas of artificial intelligence. The book covers fundamental concepts of deep learning, including neural networks, backpropagation, and various architectures like CNNs and RNNs.</p><p>With clear explanations and hands-on examples, you’ll learn how to implement deep learning models using popular frameworks and apply them to real-world problems. This book is ideal for those new to the field and looking to understand the basics of deep learning.</p>',
                'category_id' => 7,
                'brand_id' => rand(1, 5),
                'price' => rand(50, 200),
                'stock_manage' => 0,
                'stock_quantity' => 0,
                'is_readable' => 1,
                'soft_file' => 'Modules/Store/Resources/assets/files/sample.pdf',
                'type' => 1,
                'image' => 'public/frontend/infixlmstheme/img/product/13.jpg',
                'thumbnail' => 'public/frontend/infixlmstheme/img/product/13.jpg',
            ],
            [
                'user_id' => 1,
                'title' => 'Introduction to Quantum Computing',
                'description' => '<p>Introduction to Quantum Computing explores the revolutionary field of quantum computing, offering insights into its principles, algorithms, and potential applications. The book provides a clear and accessible overview of quantum mechanics, quantum gates, and quantum algorithms.</p><p>Whether you’re a student, researcher, or just curious about the future of computing, this book will give you a solid foundation in quantum computing concepts and how they are shaping the future of technology.</p>',
                'category_id' => 7,
                'brand_id' => rand(1, 5),
                'price' => rand(50, 200),
                'stock_manage' => 0,
                'stock_quantity' => 0,
                'is_readable' => 1,
                'soft_file' => 'Modules/Store/Resources/assets/files/sample.pdf',
                'type' => 1,
                'image' => 'public/frontend/infixlmstheme/img/product/14.jpg',
                'thumbnail' => 'public/frontend/infixlmstheme/img/product/14.jpg',
            ],
            [
                'user_id' => 1,
                'title' => 'Photography Essentials',
                'description' => '<p>Photography Essentials covers the fundamental techniques and skills needed to take great photos. This book introduces concepts such as composition, lighting, and camera settings, helping you improve your photography skills whether you’re a beginner or looking to refine your technique.</p><p>With practical tips, examples, and exercises, this book guides you through the art of photography, enabling you to capture stunning images and develop your own unique style. Perfect for hobbyists and aspiring photographers alike.</p>',
                'category_id' => 8,
                'brand_id' => rand(1, 5),
                'price' => rand(50, 200),
                'stock_manage' => 0,
                'stock_quantity' => 0,
                'is_readable' => 0,
                'type' => 1,
                'image' => 'public/frontend/infixlmstheme/img/product/15.jpg',
                'thumbnail' => 'public/frontend/infixlmstheme/img/product/15.jpg',
            ],
            [
                'user_id' => 1,
                'title' => 'Advanced Python Techniques',
                'description' => '<p>Advanced Python Techniques offers a deep dive into Python programming for those who have mastered the basics. This book explores advanced topics such as concurrency, parallelism, and optimization techniques that are essential for developing high-performance applications.</p><p>With detailed examples and best practices, you’ll learn how to tackle complex programming challenges and improve your coding efficiency. This book is ideal for experienced developers looking to enhance their Python skills and work on sophisticated projects.</p>',
                'category_id' => 8,
                'brand_id' => rand(1, 5),
                'price' => rand(50, 200),
                'stock_manage' => 0,
                'stock_quantity' => 0,
                'is_readable' => 0,
                'type' => 1,
                'image' => 'public/frontend/infixlmstheme/img/product/16.jpg',
                'thumbnail' => 'public/frontend/infixlmstheme/img/product/16.jpg',
            ]
        ];
        krsort($products);
         foreach ($products as $product) {
             $product=  Product::create($product);
             $product_course = new Course();
             $product_course->title = $product->title;
             $product_course->about = $product->description;
             $product_course->category_id = $product->category_id;
             $product_course->type = 5;
             $product_course->price = $product->price;
             $product_course->image = $product->image;
             $product_course->thumbnail = $product->image;
             $product_course->user_id = $product->user_id;
             $product_course->product_id = $product->id;
             $product_course->product_type = $product->type;
             $product_course->stock_manage = $product->stock_manage;
             $product_course->stock_quantity = $product->stock_quantity;

             $product_course->save();
         }



        $resetController = new StoreOrderResetController();
        $resetController->changeOrder();
    }
}
