<?php

use Illuminate\Support\Facades\Route;

Route::prefix('organization')->group(function () {
    Route::get('/', 'OrganizationController@index')->name('organization.index')->middleware('RoutePermissionCheck:organization.index');
    Route::get('/organization-data', 'OrganizationController@getAllOrganizationData')->name('getAllOrganizationData')->middleware('RoutePermissionCheck:organization.index');
    Route::get('/create', 'OrganizationController@create')->name('organization.store')->middleware('RoutePermissionCheck:organization.store');
    Route::post('/create', 'OrganizationController@store')->middleware('RoutePermissionCheck:organization.store');
    Route::get('/edit/{id}', 'OrganizationController@edit')->name('organization.update')->middleware('RoutePermissionCheck:organization.update');
    Route::post('/edit/{id}', 'OrganizationController@update')->middleware('RoutePermissionCheck:organization.update');
    Route::post('/destroy', 'OrganizationController@destroy')->name('organization.destroy')->middleware('RoutePermissionCheck:organization.destroy');


    Route::get('/sales-report', 'FinancialReportController@salesReport')->name('organization.sales_report.index');
    Route::get('/sales-report/datatable', 'FinancialReportController@salesReportDatatable')->name('organization.sales_report.datatable');

    Route::get('/financial-report', 'FinancialReportController@financialReport')->name('organization.financial_report.index');
    Route::get('/financial-report/datatable', 'FinancialReportController@financialReportDatatable')->name('organization.financial_report.datatable');

    Route::get('/payout', 'FinancialReportController@payout')->name('organization.payout.index');
    Route::get('/payout/datatable', 'FinancialReportController@payoutDatatable')->name('organization.payout.datatable');
    Route::post('/payout-submit', 'FinancialReportController@payoutSubmit')->name('organization.payout.store');
    Route::get('/payout-request-completed/{id}', 'FinancialReportController@payoutCompleted')->name('organization.payout.completed');


});


