<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateNoticeboardsTable extends Migration
{
    public function up()
    {
        Schema::create('noticeboards', function (Blueprint $table) {
            $table->id();
            $table->integer('organization_id')->unsigned()->nullable();
            $table->integer('user_id')->unsigned()->nullable();
            $table->integer('group')->default(1)->comment('1=general notification 2=course notification');
            $table->integer('type')->default(1)->comment('type comes from notice type table');
            $table->string('title')->nullable();
            $table->text('message')->nullable();
            $table->tinyInteger('status')->default(1);
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('noticeboards');
    }
}
