@extends('backend.master')
@push('styles')
    <link rel="stylesheet" href="{{asset('public/backend/css/student_list.css')}}"/>
@endpush
@php
    $table_name='users';
@endphp
@section('table')
    {{$table_name}}
@endsection

@section('mainContent')

    {!! generateBreadcrumb() !!}

    <section class="admin-visitor-area up_st_admin_visitor">
        <div class="container-fluid p-0">
            <div class="white-box">
                <div class="row justify-content-center">
                    <div class="col-12">
                        <div class="box_header common_table_header">
                            <div class="main-title d-md-flex">
                                <h3 class="mb-0 mr-30 mb_xs_15px mb_sm_20px" id="page_title">{{@$data['title']}}</h3>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-12">
                        <div class="QA_section QA_section_heading_custom check_box_table">
                            <div class="QA_table ">
                                <!-- table-responsive -->
                                <div class="">
                                    <table id="lms_table" class="table Crm_table_active3">
                                        <thead>
                                        <tr>
                                            <th scope="col">{{__('common.SL')}}</th>
                                            <th scope="col">{{__('common.Image')}}</th>
                                            <th scope="col">{{__('common.Name')}}</th>
                                            <th scope="col">{{_trans('installment.Total Purchase')}}</th>
                                            <th scope="col">{{_trans('installment.Total Installments')}}</th>
                                            <th scope="col">{{_trans('installment.Installments Count')}}</th>
                                            <th scope="col">{{_trans('installment.Overdue Installments')}}</th>
                                            <th scope="col">{{__('common.Action')}}</th>
                                        </tr>
                                        </thead>
                                        <tbody>

                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </section>

@endsection
@push('scripts')

    @if ($errors->any())
        <script>
            (function ($) {
                "use strict";
                @if(Session::has('type'))
                @if(Session::get('type')=="store")
                $('#add_student').modal('show');
                @else
                $('#editStudent').modal('show');
                @endif
                @endif
            })(jQuery);

        </script>
    @endif
    @php
        $url = route('installment.verified_users_ajax');
    @endphp


    <script>
        (function ($) {
            "use strict";
            dataTableOptions.serverSide = true
            dataTableOptions.processing = true
            dataTableOptions.ajax = '{!! $url !!}';
            dataTableOptions.columns = [
                {data: 'DT_RowIndex', name: 'id', orderable: true},
                {data: 'image', name: 'image', orderable: false},
                {data: 'name', name: 'name'},
                {data: 'total_purchase', name: 'total_purchase', searchable: false},
                {data: 'total_installment', name: 'total_installment', searchable: false},
                {data: 'installment_count', name: 'installment_count', searchable: false},
                {data: 'overdue_installment', name: 'overdue_installment', searchable: false},
                {data: 'action', name: 'action', orderable: false, searchable: false},
            ]
            dataTableOptions = updateColumnExportOption(dataTableOptions, [0, 2, 3, 4, 5, 6]);

            $('#lms_table').DataTable(dataTableOptions);
        })(jQuery);


    </script>




    <script src="{{asset('public/backend/js/student_list.js')}}"></script>

@endpush
