<?php

namespace Modules\Installment\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Request;

class PlanRequest extends FormRequest
{

    public function rules()
    {
        $code = auth()->user()->language_code;

        if (Request::route()->getName() == "installment.plan.update") {
            return [
                'title.' . $code => 'required',
                'description.' . $code => 'required',
                "capacity" => "required",
                "start_date" => "required",
                "start_time" => "required",
                "target_type" => "required",
                "end_date" => "sometimes|nullable|after_or_equal:start_date",
                "upfront" => "required",
                "upfront_type" => "required",
                'image' => 'nullable',
                'banner' => 'nullable',


            ];
        } else {
            return [
                'title.' . $code => 'required',
                'description.' . $code => 'required',
                "capacity" => "required",
                "start_date" => "required",
                "start_time" => "required",
                "target_type" => "required",
                "end_date" => "sometimes|nullable|after_or_equal:start_date",
                "upfront" => "required",
                "upfront_type" => "required",
                'image' => 'nullable',
                'banner' => 'nullable',

            ];
        }

    }


    public function authorize()
    {
        return true;
    }

    public function messages()
    {
        return validationMessage($this->rules());


    }
}
