<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreatePlanSpecificItemsTable extends Migration
{
    public function up()
    {
        Schema::create('plan_specific_items', function (Blueprint $table) {
            $table->id();
            $table->integer('installment_plan_id')->nullable();
            $table->string('target_type')->nullable()->default('all')->comment('all,course, live_class,quiz');
            $table->string('target')->nullable()->default('all')->comment('all_course,all_live_class,all_quiz', 'specific_category', 'specific_instructor', 'specific_course', 'specific_live_class', 'specific_quiz');


            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('plan_specific_items');
    }
}
