@extends('backend.master')
@section('mainContent')
    {!! generateBreadcrumb() !!}

    <section class="admin-visitor-area up_st_admin_visitor">
        <div class="container-fluid p-0">
            <div class="white-box">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="main-title">
                            <a href="{{route('gift.executeCommand')}}"
                               class="primary-btn small btn-fit fix-gr-bg float-end">
                                {{_trans('gift.Send Gift Manually')}}
                            </a>
                            <h3 class="mb-20 d-flex justify-content-between align-items-center"
                                id="page_title">{{_trans('courses.Gift List')}}</h3>

                        </div>

                        <div class="QA_section QA_section_heading_custom check_box_table">

                            <div class="QA_table ">
                                <!-- table-responsive -->
                                <div class="">
                                    <table id="lms_table" class="table Crm_table_active3">
                                        <thead>
                                        <tr>
                                            <th scope="col">{{ __('common.SL') }}</th>
                                            <th scope="col">{{ __('coupons.Title') }}</th>
                                            <th scope="col">{{ _trans('gift.Sender') }}</th>
                                            <th scope="col">{{ _trans('gift.Recipient') }}</th>
                                            <th scope="col">{{ _trans('gift.Message') }}</th>
                                            <th scope="col">{{ _trans('gift.Price') }}</th>
                                            <th scope="col">{{ _trans('gift.Gift Status') }}</th>
                                            <th scope="col">{{ __('common.Action') }}</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        @foreach($gift_records as $key => $gift_record)
                                            <tr>
                                                <th>{{ $key+1 }}</th>

                                                <td>{{@$gift_record->course->title }}</td>
                                                <td>{{@$gift_record->sender->name }}</td>
                                                <td>
                                                    {{@$gift_record->gift_receiver_name }}
                                                    <small>({{$gift_record->gift_user_email}}) </small>
                                                </td>
                                                <td>
                                                    <a href="#" class="primary-btn small tr-bg gift_message"
                                                       data-message="{{$gift_record->gift_message}}"
                                                    >{{__('common.View')}}</a>
                                                </td>
                                                <td>{{getPriceFormat($gift_record->price) }}</td>
                                                <td>{{@$gift_record->Status }}</td>
                                                <td>
                                                    <!-- shortby  -->
                                                    <div class="dropdown CRM_dropdown">
                                                        <button class="btn btn-secondary dropdown-toggle" type="button"
                                                                id="dropdownMenu2" data-bs-toggle="dropdown"
                                                                aria-haspopup="true"
                                                                aria-expanded="false">
                                                            {{ __('common.Select') }}
                                                        </button>
                                                        <div class="dropdown-menu dropdown-menu-right"
                                                             aria-labelledby="dropdownMenu2">
                                                            @if (permissionCheck('gift.send_invitation'))
                                                                <a class="dropdown-item edit_brand"
                                                                   href="{{route('gift.send_invitation',$gift_record->id)}}">{{_trans('common.Send Invitation')}}</a>
                                                            @endif
                                                            @if (permissionCheck('gift.delete') && $gift_record->gift_status == 5)
                                                                <a class="dropdown-item" data-bs-toggle="modal"
                                                                   data-bs-target="#deleteQuestionGroupModal{{$gift_record->id}}"
                                                                   href="#">{{__('common.Delete')}}</a>
                                                            @endif

                                                        </div>
                                                    </div>
                                                    <!-- shortby  -->
                                                </td>
                                            </tr>


                                            <div class="modal fade admin-query"
                                                 id="deleteQuestionGroupModal{{$gift_record->id}}">
                                                <div class="modal-dialog modal-dialog-centered">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h4 class="modal-title">{{__('common.Delete')}} {{_trans('gift.Gift')}}</h4>
                                                            <button type="button" class="btn-close"
                                                                    data-bs-dismiss="modal"><i
                                                                    class="ti-close "></i></button>
                                                        </div>

                                                        <div class="modal-body">
                                                            <div class="text-center">
                                                                <h4> {{__('common.Are you sure to delete ?')}}</h4>
                                                            </div>

                                                            <div class="mt-40 d-flex justify-content-between">
                                                                <button type="button" class="primary-btn tr-bg"
                                                                        data-bs-dismiss="modal">{{__('common.Cancel')}}</button>


                                                                <form method="POST"
                                                                      action="{{ route('gift.delete', $gift_record->id) }}"
                                                                      enctype="multipart/form-data">
                                                                    @csrf
                                                                    @method('DELETE')
                                                                    <button class="primary-btn fix-gr-bg"
                                                                            type="submit">{{__('common.Delete')}}</button>
                                                                </form>
                                                            </div>
                                                        </div>

                                                    </div>
                                                </div>
                                            </div>
                                        @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="modal fade admin-query" id="giftMessageModal">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title">{{_trans('courses.View Gift Message')}}</h4>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"><i
                                class="ti-close "></i></button>
                    </div>

                    <div class="modal-body">

                        <p id="gift_message_view">

                        </p>
                    </div>

                </div>
            </div>
        </div>
    </section>
    <div id="edit_form">

    </div>
    <div id="view_details">

    </div>
    <input type="hidden" name="status_route" class="status_route" value="{{ route('coupons.status_update') }}">

    {{-- @include('coupons::create') --}}
    @include('backend.partials.delete_modal')
@endsection
@push('scripts')
    <script src="{{asset('public/backend/js/category.js')}}"></script>

    <script>
        (function ($) {
            "use strict";
            $('.gift_message').on('click', function () {
                var message = $(this).data('message');
                $('#gift_message_view').html(message);
                $('#giftMessageModal').modal('show');
            });
        })(jQuery);

    </script>
@endpush
