<?php

namespace Modules\Chat\Notifications;

use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Messages\BroadcastMessage;
use Illuminate\Notifications\Notification;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Modules\Chat\Entities\Group;

class GroupMessageNotification extends Notification
{
    use Queueable;

    public $group;

    public function __construct(Group $group)
    {
        $this->group = $group;
    }


    public function via($notifiable)
    {
        return ['database','broadcast'];
    }

    public function toMail($notifiable)
    {
        return (new MailMessage)
                    ->line('The introduction to the notification.')
                    ->action('Notification Action', 'https://laravel.com')
                    ->line('Thank you for using our application!');
    }

    public function toArray($notifiable)
    {
        return [
            //
        ];
    }

    public function toDatabase($notifiable)
    {
        return [
            'group' => [
                'id' => $this->group->id,
                'name' => $this->group->name,
            ],
            'user' => [
                'id' => auth()->user()->id,
                'name' => auth()->user()->first_name . ' ' . auth()->user()->last_name,
            ],
            'url' => route('chat.group.show', $this->group->id)
        ];
    }

    public function toBroadcast($notifiable)
    {

        return new BroadcastMessage([
            'group' => [
                'id' => $this->group->id,
                'name' => $this->group->name,
            ],
            'user' => [
                'id' => auth()->user()->id,
                'name' => auth()->user()->first_name . ' ' . auth()->user()->last_name,
            ],
            'url' => route('chat.group.show', $this->group->id),
            'user_name' => auth()->user()->first_name . ' ' . auth()->user()->last_name,
        ]);
    }
}
