<?php

namespace Modules\Chat\Database\Seeders;

use App\Events\OneToOneConnection;
use App\User;
use Illuminate\Database\Seeder;
use Illuminate\Database\Eloquent\Model;
use Modules\CourseSetting\Entities\Course;

class ChatDatabaseSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        Model::unguard();

        $courses = Course::whereNull('quiz_id', )->get();

        foreach ($courses as $assignCourses){
            $instructor = User::find($assignCourses->user_id);
            foreach ($assignCourses->enrollUsers as $student){
                event(new OneToOneConnection($instructor, $student,$assignCourses));
            }
        }

        UpdateGeneralSetting('chat_generate', 'generated');
        UpdateGeneralSetting('chatting_method', 'pusher');

        $data =  [
            'pusher_app_id' => '1901718',
            'pusher_app_key' => 'cf755cfab7b1053d2d36',
            'pusher_app_secret' => 'c553d3c01b036869540b',
            'pusher_app_cluster' => 'ap2',
        ];

        putEnvConfigration('BROADCAST_DRIVER','pusher');
        foreach ($data as $key => $val) {
            putEnvConfigration(strtoupper($key),$val);
        }
    }
}
