<?php

use Illuminate\Support\Facades\Route;
use Modules\Cashback\Http\Controllers\CashbackController;
use Modules\Cashback\Http\Controllers\StudentCashbackController;



Route::prefix('cashback')->middleware(['auth', 'admin'])->name('cashback.')->group(function () {
    Route::get('/', [CashbackController::class, 'index'])->name('rules')->middleware('RoutePermissionCheck:cashback.rules');
    Route::get('/create', [CashbackController::class, 'create'])->name('rules.create')->middleware('RoutePermissionCheck:cashback.rules.create');
    Route::post('/store', [CashbackController::class, 'store'])->name('rules.store')->middleware('RoutePermissionCheck:cashback.rules.create');
    Route::get('/edit/{id}', [CashbackController::class, 'edit'])->name('rules.edit')->middleware('RoutePermissionCheck:cashback.rules.edit');
    Route::post('/update', [CashbackController::class, 'update'])->name('rules.update')->middleware('RoutePermissionCheck:cashback.rules.edit');
    Route::post('/delete', [CashbackController::class, 'destroy'])->name('rules.delete')->middleware('RoutePermissionCheck:cashback.rules.delete');
    Route::get('/transaction', [CashbackController::class, 'transaction'])->name('transaction')->middleware('RoutePermissionCheck:cashback.transaction');
    Route::get('/transaction-ajax', [CashbackController::class, 'transactionLoad'])->name('transaction_ajax')->middleware('RoutePermissionCheck:cashback.transaction');
    Route::get('/transaction-refund/{trans_id}', [CashbackController::class, 'transactionRefund'])->name('transaction_refund')->middleware('RoutePermissionCheck:cashback.transaction_refund');
    Route::get('/history', [CashbackController::class, 'history'])->name('history')->middleware('RoutePermissionCheck:cashback.history');
    Route::get('/history-ajax', [CashbackController::class, 'historyLoad'])->name('history_ajax')->middleware('RoutePermissionCheck:cashback.history');
    Route::get('/user-cashback-status/{user_id}', [CashbackController::class, 'userCashbackStatus'])->name('user_cashback_status')->middleware('RoutePermissionCheck:cashback.user_cashback_status');
});
Route::prefix('cashback')->middleware(['auth'])->name('cashback.')->group(function () {
    Route::get('/my-cashback', [StudentCashbackController::class, 'studentCashbackList'])->name('my-cashback');
});
