<?php

namespace Modules\Cashback\Entities;

use App\User;
use Illuminate\Database\Eloquent\Model;
use Modules\CourseSetting\Entities\Category;
use Modules\CourseSetting\Entities\Course;

class RuleSpecificItemDetail extends Model
{
    protected $fillable = ['rule_specific_item_id', 'item_id', 'type'];

    public function rule_specific_item()
    {
        return $this->belongsTo(RuleSpecificItem::class);
    }


    public function itemInfo()
    {
        $role_specific_item = $this->rule_specific_item;

        //Course
        if ($role_specific_item->target_type == 'course') {
            if ($role_specific_item->target == 'specific_category') {
                return $this->belongsTo(Category::class, 'item_id', 'id')->select('id', 'name');
            } elseif ($role_specific_item->target == 'specific_course') {
                return $this->belongsTo(Course::class, 'item_id', 'id')->select('id', 'title as name');
            } elseif ($role_specific_item->target == 'specific_instructor') {
                return $this->belongsTo(User::class, 'item_id', 'id')->select('id', 'name');
            } elseif ($role_specific_item->target == 'all_course') {
                return _trans('cashback.All Courses');
            } else {
                return [];
            }
        }

        //Quiz
        if ($role_specific_item->target_type == 'quiz') {
            if ($role_specific_item->target == 'specific_quiz') {
                return $this->belongsTo(Course::class, 'item_id', 'id');
            } elseif ($role_specific_item->target == 'specific_instructor') {
                return $this->belongsTo(User::class, 'item_id', 'id');
            } elseif ($role_specific_item->target == 'all_quiz') {
                return _trans('cashback.All Quizzes');
            } else {
                return [];
            }
        }

        //Live class
        if ($role_specific_item->target_type == 'live_class') {
            if ($role_specific_item->target == 'specific_class') {
                return $this->belongsTo(Course::class, 'item_id', 'id');
            } elseif ($role_specific_item->target == 'specific_instructor') {
                return $this->belongsTo(User::class, 'item_id', 'id');
            } elseif ($role_specific_item->target == 'all_live_class') {
                return _trans('cashback.All Classes');
            } else {
                return [];
            }
        }
        //Upcoming Course
        if ($role_specific_item->target_type == 'upcoming_course') {
            if ($role_specific_item->target == 'specific_category') {
                return $this->belongsTo(Category::class, 'item_id', 'id')->select('id', 'name');
            } elseif ($role_specific_item->target == 'specific_course') {
                return $this->belongsTo(Course::class, 'item_id', 'id')->select('id', 'title as name');
            } elseif ($role_specific_item->target == 'specific_instructor') {
                return $this->belongsTo(User::class, 'item_id', 'id')->select('id', 'name');
            } elseif ($role_specific_item->target == 'all_course') {
                return _trans('cashback.All Courses');
            } else {
                return [];
            }
        }
    }
}
