
@if(isset($editInstructor))
    @foreach ($editInstructor->teachingLanguages as $key => $teachingLanguage)
    <div class="row mt-25">
        <div class="col-xl-6">
            <label class="primary_input_label"
                for="category">{{ __('courses.Language') }}</label>
            <select class="primary_select" name="teachingLanguage[{{ $key+100 }}][language]" id="language">
                <option data-display="{{ __('common.Select Language') }}"
                    value="">{{ __('common.Select Language') }}</option>
                @foreach ($languages as $lang)
                    <option value="{{ $lang->id }}" {{ $teachingLanguage->language_id == $lang->id ? 'selected':'' }}>{{ @$lang->name }} </option>
                @endforeach
            </select>
        </div>
        <div class="col-xl-5">
            <label class="primary_input_label"
                for="category">{{ __('courses.Level') }}</label>
            <select class="primary_select" name="teachingLanguage[{{ $key+100 }}][level]" id="langauageLevel">
                <option data-display="{{ __('appointment.Select Level') }}" value="">
                    {{ __('appointment.Select Level') }}</option>
                @foreach ($levels as $level)
                    <option value="{{ $level->id }}" {{ $teachingLanguage->level_id == $level->id ? 'selected':'' }}>{{ @$level->title }} </option>
                @endforeach
            </select>
        </div>
        <div class="col-xl-1 mt-33">
            <button class="removeTeachingLanguageBtn primary-btn icon-only fix-gr-bg fl-r"
                type="button">
                <span class="ti-trash"></span> </button>
        </div>
    </div>
    @endforeach
    @if (count($editInstructor->teachingLanguages)==0)
        @includeIf('appointment::instructor.inc.create_teachingLanguage')
    @endif
@endif
