<div class="tutor_listing_details_content">
    @includeIf('appointment::frontend.inc._info')
    <div class="tutor_listing_details_content_info">
        <div class="tutor_listing_details_content_info_title" id='top-menu'>
            <ul>
                <li><a href="#about" class='menu_link active'>{{ __('appointment.About') }}</a></li>
                <li><a class="menu_link" href="#schedule">{{ __('appointment.Schedule') }}</a></li>
                @if($settings->review_option == 1)
                    <li><a class="menu_link" href="#reviews">{{ __('appointment.Reviews') }}
                            ({{ $instructor->instructor_reviews_count }})</a></li>
                @endif
                <li><a class="menu_link" href="#resume">{{ __('appointment.Resume') }}</a></li>
                <li><a class="menu_link" href="#course">{{ __('courses.Course') }}</a></li>
            </ul>
        </div>
        <div class="tutor_listing_details_content_info_card" id='about'>
            <h4>{{ __('appointment.About the tutor') }}</h4>
            {!! $instructor->about !!}
            <a href="#">{{ __('appointment.Read More') }}</a>
        </div>
        <div class="tutor_listing_details_content_info_card" id="schedule">
            @includeIf('appointment::frontend.inc._inner_schedule')
        </div>
        @if($settings->review_option == 1)
            <div class="tutor_listing_details_content_info_card" id='reviews'>
                @includeIf('appointment::frontend.inc._review')
            </div>
        @endif
        <div class="tutor_listing_details_content_info_card" id="resume">
            @includeIf('appointment::frontend.inc._resume')
        </div>

        <div class="tutor_listing_details_content_info_card" id="course">
            @includeIf('appointment::frontend.inc._course')
        </div>
    </div>
</div>
<script>
    (function ($) {
        "use strict";

        $(document).on('click', '.menu_link', function () {
            $('.menu_link').removeClass('active');
            $(this).addClass('active')
        })

    })(jQuery);
</script>
