<?php

namespace Modules\Appointment\Entities;

use App\Traits\Tenantable;
use Illuminate\Database\Eloquent\Model;

class AppointmentFrontendPage extends Model
{
    use Tenantable;

    protected $guarded = ['id'];

    public function design()
    {
        return $this->belongsTo(Design::class, 'design_id', 'id');
    }
    public static function description($name, $type = null)
    {
        return AppointmentFrontendPage::where('status', 1)
        ->where('name', $name)
        ->when($type, function ($query) use ($type) {
            $query->where('type', $type);
        })
        ->value('description');
    }
}
