<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Default Filesystem Disk
    |--------------------------------------------------------------------------
    |
    | Here you may specify the default filesystem disk that should be used
    | by the framework. The "local" disk, as well as a variety of cloud
    | based disks are available to your application. Just store away!
    |
    */

    'default' => env('FILESYSTEM_DRIVER', 'local'),

    /*
    |--------------------------------------------------------------------------
    | Default Cloud Filesystem Disk
    |--------------------------------------------------------------------------
    |
    | Many applications store files both locally and in the cloud. For this
    | reason, you may specify a default "cloud" driver here. This driver
    | will be bound as the Cloud disk implementation in the container.
    |
    */

    'cloud' => env('FILESYSTEM_CLOUD', 's3'),

    /*
    |--------------------------------------------------------------------------
    | Filesystem Disks
    |--------------------------------------------------------------------------
    |
    | Here you may configure as many filesystem "disks" as you wish, and you
    | may even configure multiple disks of the same driver. Defaults have
    | been setup for each driver as an example of the required options.
    |
    | Supported Drivers: "local", "ftp", "sftp", "s3", "rackspace"
    |
    */

    'disks' => [

        'local' => [
            'driver' => 'local',
            'root' => storage_path('app'),   //change here
//            'root' => public_path(),
        ],

        'public' => [
            'driver' => 'local',
            'root' => storage_path('app/public'),
            'url' => env('APP_URL') . '/storage',
            'visibility' => 'public',
        ],

        's3' => [
            'driver' => 's3',
            'key' => saasEnv('AWS_ACCESS_KEY_ID'),
            'secret' => saasEnv('AWS_SECRET_ACCESS_KEY'),
            'region' => saasEnv('AWS_DEFAULT_REGION'),
            'bucket' => saasEnv('AWS_BUCKET'),
            'url' => saasEnv('AWS_URL'),
            'visibility' => 'public',
        ], 'google' => [
            'driver' => 'google',
            'clientId' => saasEnv('GOOGLE_DRIVE_CLIENT_ID'),
            'clientSecret' => saasEnv('GOOGLE_DRIVE_CLIENT_SECRET'),
//            'projectId' => saasEnv('GOOGLE_DRIVE_PROJECT_ID'),
            'redirect' => saasEnv('GOOGLE_DRIVE_REDIRECT'),
        ],
        'dropbox' => [
            'driver' => 'dropbox',
            'key' => saasEnv('DROPBOX_APP_KEY'),
            'secret' => saasEnv('DROPBOX_APP_SECRET'),
            'authorization_token' => saasEnv('DROPBOX_AUTHORIZATION_TOKEN'),
        ],
        'custom' => [
            'driver' => 'local',
            'root' => base_path() . '/public/uploads',
        ],
        'hls' => [
            'driver' => 'local',
            'root' => base_path() . '/public/uploads/hls',
        ],
        'root' => [
            'driver' => 'local',
            'root' => base_path(),
        ],
        'contabo' => [
            'driver' => 's3',
            'key' => saasEnv('CONTABO_ACCESS_KEY_ID'),
            'secret' => saasEnv('CONTABO_SECRET_ACCESS_KEY'),
            'region' => saasEnv('CONTABO_DEFAULT_REGION'),
            'bucket' => saasEnv('CONTABO_BUCKET'),
            'url' => saasEnv('CONTABO_URL'),
            'endpoint' => saasEnv('CONTABO_ENDPOINT'),
            'use_path_style_endpoint' => true,
            'throw' => false,
        ],

        'do' => [
            'driver' => 's3',
            'key' => saasEnv('DO_ACCESS_KEY_ID'),
            'secret' => saasEnv('DO_SECRET_ACCESS_KEY'),
            'region' => saasEnv('DO_DEFAULT_REGION'),
            'bucket' => saasEnv('DO_BUCKET'),
            'endpoint' => saasEnv('DO_ENDPOINT'),
        ],


        'Wasabi' => [
            'driver' => 's3',
            'key' => saasEnv('WASABI_ACCESS_KEY_ID'),
            'secret' => saasEnv('WASABI_SECRET_ACCESS_KEY'),
            'region' => saasEnv('WASABI_DEFAULT_REGION'),
            'bucket' => saasEnv('WASABI_BUCKET'),
            'endpoint' => saasEnv('WASABI_ENDPOINT'),
        ],
        'b2' => [
            'driver' => 'b2',
            'accountId' => saasEnv('BACKBLAZE_KEY_ID'),
            'applicationKey' => saasEnv('BACKBLAZE_APPLICATION_KEY'),
            'bucketName' => saasEnv('BACKBLAZE_BUCKET_NAME'),
            'bucketId' => saasEnv('BACKBLAZE_BUCKET_ID'),
        ],


    ],

];
