<?php

namespace Modules\WhatsappSupport\Entities;

use App\Traits\Tenantable;
use Illuminate\Database\Eloquent\Model;
use Modules\Setting\Entities\UsedMedia;

class Agents extends Model
{
    use Tenantable;

    protected $guarded = [];

    protected $table = 'whatsapp_support_agents';


    public function times()
    {
        return $this->hasMany(AgentTime::class, 'agent_id', 'id');
    }

    public function isAvailable()
    {
        if ($this->always_available) return true;

        if ($this->times->where('day', now()->dayName)->first()) {
            $row = $this->times->where('day', now()->dayName)->first();
            return $row->start_time_str < strtotime(now()->format('H:s:i')) && $row->end_time_str > strtotime(now()->format('H:s:i'));
        }

        return false;

    }

    public function avater_media()
    {
        return $this->morphOne(UsedMedia::class, 'usable')->where('used_for', 'avatar');
    }

}
