<?php

namespace Modules\UserType\Http\Controllers;

use App\Http\Controllers\Controller;
use App\User;
use Brian2694\Toastr\Facades\Toastr;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Modules\Org\Entities\OrgBranch;
use Modules\RolePermission\Entities\Role;
use Yajra\DataTables\Facades\DataTables;

class UserTypeController extends Controller
{

    public function index()
    {
        $query = Role::where('id', '!=', 1);
        if (isModuleActive('Org')) {
            $query->whereIn('id', [2, 3]);
        }
        $roles = $query->pluck('name', 'id');
        $data = [];
        if (isModuleActive('Org')) {
            $data['branches'] = OrgBranch::where('parent_id', 0)->get();
        }
        return view('usertype::index', $data, compact('roles'));
    }

    public function settingSubmit(Request $request)
    {
        try {
            $user = User::with('userRoles')->find($request->user);
            if ($request->boolean('status')) {
                $user->userRoles()->attach($request->role);
                if ($user->role_id == 0) {
                    $user->role_id = $request->role;
                    $user->save();
                }
            } else {
                $user->userRoles()->detach($request->role);
                if ($user->role_id == $request->role) {
                    $user->role_id = 0;
                    $user->save();
                }
            }
            return true;
        } catch (Exception $e) {
            return false;

        }
    }

    public function assignOrg(Request $request)
    {
        try {
            $user = User::find($request->user);
            $user->org_chart_code = $request->org;
            $user->save();
            return true;
        } catch (Exception $e) {
            return false;

        }
    }

    public function data(Request $request)
    {
        $roles = Role::pluck('name', 'id');
        $query = User::with('userRoles')->where('id', '!=', 1);

        if (!empty($request->roles)) {
            $query->whereHas('userRoles', function ($q) {
                $q->whereIn('role_id', \request('roles'));
            });
        }
        if (isModuleActive('LmsSaas')) {
            $query->where('lms_id', app('institute')->id);
        } else {
            $query->where('lms_id', 1);
        }


        $datatable = Datatables::of($query)
            ->addIndexColumn()
            ->editColumn('name', function ($query) {
                return $query->name;
            });


        $rows = [];
        foreach ($roles as $key => $role) {
            $rows[] = 'role_' . $key;
            $datatable->addColumn('role_' . $key, function ($query) use ($role, $key) {
                $button = '';
                if ($key == 3) {
                    if (isModuleActive('Org')) {
                        if (!empty($query->org_chart_code)) {
                            $branch = $query->org_chart_code;
                        } else {
                            $branch = trans('org.Branch');
                        }

                        $button .= '<button   data-user="' . $query->id . '"
                            data-role="' . $key . '"
                            data-branch="' . $branch . '"
                            type="button"
                            class="primary-btn radius_30px   fix-gr-bg branchModal
                             ' . ($query->hasRole(3) ? "" : 'd-none') . '
                            ">' . $branch . '</button>';

                    }
                }
                return '<div class="flex-nowrap"> <label class="primary_checkbox  mr-12">
                            <input type="checkbox" class="userSelect"
                            ' . ($query->hasRole($key) ? 'checked' : "") . '
                            name="users[' . $query->id . ']"
                            data-user="' . $query->id . '"
                            data-role="' . $key . '">
                            <span class="checkmark me-2"></span>
                        </label>' . $button . '</div>';
            });
        }

        $datatable->rawColumns($rows);
        return $datatable->make(true);
    }


    public function changePanel($role_id)
    {
        if (auth()->user()->hasRole($role_id)) {
            $user = auth()->user();
            $user->role_id = $role_id;
            $user->save();
            Toastr::success(trans('common.Operation successful'), trans('common.Success'));
        } else {
            Toastr::error(trans('common.Operation failed'), trans('common.Failed'));

        }
        if (Auth::user()->role_id == 3) {
            return redirect()->route('studentDashboard');
        } else {
            return redirect()->route('dashboard');
        }
    }


}
