@extends('backend.master')
@push('styles')
    <link rel="stylesheet" href="{{ asset('public/backend/css/daterangepicker.css') }}">
@endpush


@php
    $table_name='courses';
    $url = route('admin.upcoming_courses.datatable');
@endphp
@section('table')
    {{$table_name}}
@stop
@section('mainContent')
    {!! generateBreadcrumb() !!}
    <section class="admin-visitor-area up_st_admin_visitor">
        <div class="container-fluid p-0">

            <div class="row justify-content-center">
                <div class="col-lg-12">
                    <div class="white_box mb_30">
                        <div class="white_box_tittle list_header main-title mb-0">
                            <h3 class="mb-0">{{__('courses.Advanced Filter')}} </h3>
                        </div>
                        <form action="#" method="POST">
                            @csrf
                            <div class="row">

                                <div class="col-lg-3 mt-20">

                                    <label class="primary_input_label" for="category">{{__('courses.Category')}}</label>
                                    <select class="primary_select" name="category" id="f_category">
                                        <option data-display="{{__('common.Select')}} {{__('courses.Category')}}"
                                                value="">{{__('common.Select')}} {{__('courses.Category')}}</option>
                                        @foreach($categories as $category)
                                            @if($category->parent_id==0)
                                                @include('backend.categories._single_select_option',['category'=>$category,'level'=>1])
                                            @endif
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-lg-3 mt-20">

                                    <label class="primary_input_label" for="type">{{__('courses.Type')}}</label>
                                    <select class="primary_select" name="type" id="f_type">
                                        <option data-display="{{__('common.Select')}} {{__('courses.Type')}}"
                                                value="">{{__('common.Select')}} {{__('courses.Type')}}</option>
                                        <option
                                            value="1" {{isset($category_type)?$category_type==1?'selected':'':''}}>{{__('courses.Course')}}</option>
                                        <option
                                            value="2" {{isset($category_type)?$category_type==2?'selected':'':''}}>{{__('quiz.Quiz')}}</option>
                                    </select>

                                </div>
                                <div class="col-lg-3 mt-20">

                                    <label class="primary_input_label"
                                           for="instructor">{{__('courses.Instructor')}}</label>
                                    <select class="primary_select" name="instructor" id="f_instructor">
                                        <option data-display="{{__('common.Select')}} {{__('courses.Instructor')}}"
                                                value="">{{__('common.Select')}} {{__('courses.Instructor')}}</option>
                                        @foreach($instructors as $instructor)
                                            <option
                                                value="{{$instructor->id}}" {{isset($category_instructor)?$category_instructor==$instructor->id?'selected':'':''}}>{{@$instructor->name}} </option>
                                        @endforeach
                                    </select>

                                </div>
                                <div class="col-lg-3 mt-20 d-none">
                                    <label class="primary_input_label" for="course">{{__('courses.Statistics')}}</label>
                                    <select class="primary_select" name="course" id="course">
                                        <option data-display="{{__('common.Select')}} {{__('courses.Statistics')}}"
                                                value="">{{__('common.Select')}} {{__('courses.Statistics')}}</option>
                                        <option value="statistics">{{__('courses.Statistics')}}</option>
                                        <option value="topSell">Top Sells</option>
                                        <option value="mostReview">Most Review</option>
                                        <option value="mostComment">Most Comment</option>
                                        <option value="topReview">Top Review</option>
                                    </select>

                                </div>
                                <div class="col-lg-3 mt-20">

                                    <label class="primary_input_label" for="status">{{__('common.Status')}}</label>
                                    <select class="primary_select" name="search_status" id="f_status">
                                        <option data-display="{{__('common.Select')}} {{__('common.Status')}}"
                                                value="">{{__('common.Select')}} {{__('common.Status')}}</option>
                                        <option
                                            value="1" {{isset($category_status)?$category_status=="1"?'selected':'':''}}>{{__('courses.Active')}} </option>
                                        <option
                                            value="0" {{isset($category_status)?$category_status!="1"?'selected':'':''}}>{{__('courses.Pending')}} </option>
                                    </select>

                                </div>

                                <div class="col-lg-3 mt-20">

                                    <label class="primary_input_label"
                                           for="f_publish_status">{{__('courses.Publish Status')}}</label>
                                    <select class="primary_select" name="f_publish_status" id="f_publish_status">
                                        <option value="">{{__('common.Select One')}}</option>
                                        <option value="pending">Pending</option>
                                        <option value="published">Published</option>
                                    </select>

                                </div>

                                <div class="col-lg-3 mt-20">
                                    <div class="primary_input mb-15 date_range">
                                        <div class="primary_datepicker_input filter">
                                            <label class="primary_input_label"
                                                   for="">{{__('courses.Publish Date')}}</label>
                                            <div class="g-0 input-right-icon">
                                                <div class="col">
                                                    <div class="">
                                                        <input placeholder="{{__('courses.Publish Date')}}" readonly
                                                               class="primary_input_field date_range_input" type="text"
                                                               name="date_range_filter" value="">
                                                    </div>
                                                </div>
                                                <button class="" type="button">
                                                    <i class="fa fa-refresh" id="reset-date-filter"></i>
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                @if(isModuleActive('Org'))
                                    <div class="col-lg-3 mt-20">
                                        <label class="primary_input_label"
                                               for="search_required_type">{{__('courses.Required Type')}}</label>
                                        <select class="primary_select" name="search_required_type"
                                                id="f_search_required_type">
                                            <option
                                                data-display="{{__('common.Select')}} {{__('courses.Required Type')}}"
                                                value="">{{__('common.Select')}} {{__('courses.Required Type')}}</option>
                                            <option
                                                value="1" {{isset($search_required_type)?$search_required_type=="1"?'selected':'':''}}>{{__('courses.Compulsory')}} </option>
                                            <option
                                                value="0" {{isset($search_required_type)?$search_required_type=="0"?'selected':'':''}}> {{__('courses.Open')}}</option>
                                        </select>

                                    </div>

                                    <div class="col-lg-3 mt-20">

                                        <label class="primary_input_label"
                                               for="status">{{__('courses.Delivery Mode')}}</label>
                                        <select class="primary_select" name="search_delivery_mode"
                                                id="f_search_delivery_mode">
                                            <option
                                                data-display="{{__('common.Select')}} {{__('courses.Delivery Mode')}}"
                                                value="">{{__('common.Select')}} {{__('courses.Delivery Mode')}}</option>
                                            <option
                                                value="1" {{isset($search_delivery_mode)?$search_delivery_mode=="1"?'selected':'':''}}>{{__('courses.Online')}} </option>
                                            <option
                                                value="3" {{isset($search_delivery_mode)?$search_delivery_mode=="3"?'selected':'':''}}>{{__('courses.Offline')}}</option>
                                        </select>

                                    </div>
                                @endif
                                <div class="col-12  ">
                                    <div class="search_course_btn text-end">
                                        <button type="button"
                                                class="primary-btn radius_30px fix-gr-bg reset_btn">{{__('common.Reset')}} </button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
                <div class="col-12">
                    <div class="white-box">
                        <div class="row">
                            <div class="col-12">
                                <div class="box_header common_table_header">
                                    <div class="main-title d-md-flex">
                                        <h3 class="mb-0 mr-30 mb_xs_15px mb_sm_20px"
                                            id="page_title">{{$title??""}} {{__('courses.Course')}}
                                            /{{__('quiz.Quiz')}} {{__('courses.List')}}</h3>
                                        @if (permissionCheck('course.store'))
                                            <ul class="d-flex">
                                                <li>


                                                    <a class="primary-btn radius_30px fix-gr-bg"
                                                       href="{{route('course.store')}}">
                                                        <i class="ti-plus"></i>{{__('common.Add')}} {{__('courses.Course')}}
                                                        /{{__('quiz.Quiz')}}</a>
                                                </li>
                                            </ul>
                                        @endif
                                    </div>

                                </div>
                            </div>

                            <div class="col-lg-12">
                                <div class="QA_section QA_section_heading_custom check_box_table">
                                    <div class="QA_table">
                                        <!-- table-responsive -->
                                        <div class="">
                                            <table id="lms_table" class="table classList">
                                                <thead>
                                                <tr>
                                                    <th scope="col"> {{__('common.SL')}}</th>
                                                    <th scope="col"> {{__('coupons.Type')}}</th>
                                                    @if(isModuleActive('Org'))
                                                        <th scope="col"> {{__('courses.Required Type')}}</th>
                                                    @endif
                                                    <th scope="col">{{__('courses.Course')}}
                                                        /{{__('quiz.Quiz')}} {{__('coupons.Title')}}</th>
                                                    <th scope="col">{{__('courses.Publish Date')}}</th>
                                                    <th scope="col">{{__('courses.Publish Status')}}</th>
                                                    <th scope="col">{{__('courses.Is Allow Prebooking')}}</th>
                                                    <th scope="col">{{__('courses.Booking Amount')}}</th>

                                                    <th scope="col">{{__('courses.Delivery')}}</th>
                                                    <th scope="col">{{__('quiz.Category')}}</th>
                                                    @if(!isModuleActive('Org'))
                                                        <th scope="col">{{__('quiz.Quiz')}}</th>
                                                    @endif
                                                    <th scope="col">{{__('courses.Instructor')}}</th>
                                                    <th scope="col">{{__('courses.Lesson')}}</th>
                                                    <th scope="col">{{__('courses.Enrolled')}}</th>
                                                    @if(showEcommerce())
                                                        <th scope="col">{{__('courses.Price')}}</th>
                                                    @endif
                                                    <th scope="col">{{__('courses.View Scope')}}</th>
                                                    <th scope="col">{{__('common.Status')}}</th>
                                                    <th scope="col">{{__('common.Action')}}</th>
                                                </tr>
                                                </thead>
                                                <tbody>

                                                </tbody>
                                            </table>

                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>


            </div>


        </div>
    </section>

    <div class="modal fade admin-query" id="publish_course">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">{{__('courses.Publish Course')}}</h4>
                    <button type="button" class="btn-close" data-bs-dismiss="modal">
                        <i class="ti-close "></i>
                    </button>
                </div>
                <div class="modal-body">
                    <h3 class="text-center">Are you want to publish course ?</h3>

                    <div class="col-lg-12 text-center">
                        <div class="mt-40 d-flex justify-content-between">
                            <button type="button" class="primary-btn tr-bg"
                                    data-bs-dismiss="modal">{{__('common.Cancel')}}</button>
                            <a id="publish_link" class="primary-btn semi_large2 fix-gr-bg">{{__('courses.Publish')}}</a>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @include('backend.partials.delete_modal')
@endsection
@push('scripts')
    <script src="{{asset('public/backend/js/daterangepicker.min.js')}}"></script>
    <script src="{{asset('/')}}/Modules/CourseSetting/Resources/assets/js/course.js"></script>



    <script>
        (function ($) {
            "use strict";
            dataTableOptions.serverSide = true
            dataTableOptions.processing = true
            dataTableOptions.ajax = {
                url: '{!! $url !!}',
                data: function (d) {
                    d.category = $('#f_category').val();
                    d.type = $('#f_type').val();
                    d.instructor = $('#f_instructor').val();
                    d.search_status = $('#f_status').val();
                    d.search_required_type = $('#f_search_required_type').val();
                    d.search_delivery_mode = $('#f_search_delivery_mode').val();
                    d.publish_status = $('#f_publish_status').val();
                    d.f_date = $('.date_range_input').val()

                }
            };

            dataTableOptions.columns = [
                {data: 'DT_RowIndex', name: 'id'},
                {data: 'type', name: 'type'},
                    @if(isModuleActive('Org'))
                {
                    data: 'required_type', name: 'required_type'
                },
                    @endif
                {
                    data: 'title', name: 'title'
                },
                {
                    data: 'publish_date', name: 'publish_date'
                },
                {
                    data: 'publish_status', name: 'publish_status'
                },
                {
                    data: 'is_allow_prebooking', name: 'is_allow_prebooking'
                },
                {
                    data: 'booking_amount', name: 'booking_amount'
                },
                {data: 'mode_of_delivery', name: 'mode_of_delivery'},
                {data: 'category', name: 'category.name'},
                    @if(!isModuleActive('Org'))
                {
                    data: 'quiz', name: 'quiz.title'
                },
                    @endif
                {
                    data: 'user', name: 'user.name'
                },

                {data: 'lessons', name: 'lessons'},
                {data: 'enrolled_users', name: 'enrolled_users'},
                    @if(showEcommerce())
                {
                    data: 'price', name: 'price'
                }, @endif
                {
                    data: 'scope', name: 'scope'
                },
                {data: 'status', name: 'search_status', orderable: false, searchable: false},
                {
                    data: 'action', name: 'action', orderable: false
                },
            ];

            let table = $('.classList').DataTable(dataTableOptions);


            $(document).on('click', '.publish_course', function (event) {
                event.preventDefault();
                let action = $(this).attr('href');
                $('#publish_link').attr('href', action);
                $("#publish_course").modal('show');
            });

            $(document).on('click', '.reset_btn', function (event) {
                event.preventDefault();
                $('#f_category').val('').niceSelect('update');
                $('#f_type').val('').niceSelect('update');
                $('#f_instructor').val('').niceSelect('update');
                $('#f_status').val('').niceSelect('update');
                $('#f_search_required_type').val('').niceSelect('update');
                $('#f_search_delivery_mode').val('').niceSelect('update');
                $('#f_publish_status').val('').niceSelect('update');
                $('.date_range_input').val('');
                resetAfterChange();
            });

            var selector = ".date_range_input"
            $(selector).on('apply.daterangepicker', function (ev, picker) {
                $(this).val(picker.startDate.format('MM/DD/YYYY') + ' - ' + picker.endDate.format('MM/DD/YYYY'));
                resetAfterChange();
            });

            $(selector).daterangepicker({
                autoUpdateInput: false,
                locale: {
                    cancelLabel: 'Clear'
                },
                opens: rtl == "rtl" ? "left" : "right",

                ranges: {
                    'Today': [moment(), moment()],
                    'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                    'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                    'Last 30 Days': [moment().subtract(29, 'days'), moment()],
                    'This Month': [moment().startOf('month'), moment().endOf('month')],
                    'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
                    'This Year': [moment().startOf('year'), moment().endOf('year')],
                    'Last Year': [moment().subtract(1, 'year').startOf('year'), moment().subtract(1, 'year').endOf('year')],
                }


            }, function (start, end, label) {

            });

            $(document).on('change', '#f_category,#f_type,#f_instructor,#f_status,#f_search_required_type,#f_search_delivery_mode,#f_publish_status', function (event) {
                event.preventDefault();
                resetAfterChange();
            });


            function resetAfterChange() {
                let table = $('.classList').DataTable();
                table.clearPipeline();
                table.ajax.reload();
            }
        })(jQuery);
    </script>
@endpush
