<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Modules\SystemSetting\Entities\EmailTemplate;

class AddEmailTemplateTwoFactorAuthentication extends Migration
{
    public function up()
    {
        $payslip_template = EmailTemplate::where('act', 'Two_Factor_Authentication')->first();
        if (!$payslip_template) {
            $payslip_template = new EmailTemplate();
            $payslip_template->act = 'Two_Factor_Authentication';
        }
        $shortCode = '{"otp_code":"Otp Code","email":"Email", "expired_time":"Expired Time"}';
        $subject = 'Two Factor Authentication';

        $br = "<br/>";
        $body = "Dear User." . $br . $br . " You are welcome to login in LMS." . $br . " To login kindly use this otp code. " . $br . $br . " <h3>{{otp_code}}</h3>
        " . $br . $br . "Kindly get in touch with the admin in case of any questions. " . $br . "Please note that, the above otp code will expired within {{expired_time}} Minutes. " . $br . $br . " Thanks, " . $br . "
        LMS Team";
        $payslip_template->name = $subject;
        $payslip_template->subj = $subject;
        $payslip_template->shortcodes = $shortCode;
        $payslip_template->status = 1;
        $payslip_template->is_system = 0;
        $payslip_template->browser_message = 'Two Factor Authentication in LMS';

        $payslip_template->email_body = htmlPart($subject, $body);
        $payslip_template->save();
    }

}
