@php
    $options = [
                'checkbox',
                'dropdown',
                'radio'
            ];
@endphp
@extends('backend.master')
@section('mainContent')
    @push('styles')
        <style>
            .optionCorrect {
                display: none;
            }

            .optionTitle {
                max-width: 100%;
                flex: 0 0 100%;

            }

            .invalid-feedback.invalid-select strong {
                top: 70px;
            }

        </style>
    @endpush
    {!! generateBreadcrumb() !!}
    <section class="admin-visitor-area up_st_admin_visitor">
        <div class="container-fluid p-0">
            <div class="white-box">

                <div class="row">
                    <div class="col-lg-12">
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="main-title">
                                    <h3 class="mb-20">
                                        @if(isset($bank))
                                            {{__('common.Edit')}}

                                        @else
                                            {{__('common.Add')}}
                                        @endif
                                        {{__('survey.Survey Bank')}}
                                    </h3>
                                </div>

                                @if(isset($bank))

                                    <form method="POST" action="{{ route('survey.survey-bank-update', $bank->id) }}"
                                          class="form-horizontal" id="question_bank">
                                        @method('PUT')
                                        @else

                                            <form method="POST" action="{{ route('survey.survey-bank.store') }}"
                                                  class="form-horizontal" id="question_bank"
                                                  enctype="multipart/form-data">

                                                @endif
                                                @csrf

                                                <input type="hidden" name="url" id="url" value="{{URL::to('/')}}">
                                                <div class="add-visitor">
                                                    <div class="row">
                                                        <div class="col-lg-4">

                                                            <label class="primary_input_label"
                                                                   for="groupInput">{{__('quiz.Group')}} <span
                                                                    class='required_mark'>*</span></label>
                                                            <select {{ $errors->has('group') ? ' autofocus' : '' }}
                                                                    class="primary_select{{ $errors->has('group') ? ' is-invalid' : '' }}"
                                                                    name="group" id="groupInput">
                                                                <option
                                                                    data-display="{{__('common.Select')}} {{__('quiz.Group')}} "
                                                                    value="">{{__('common.Select')}} {{__('quiz.Group')}}
                                                                </option>
                                                                @foreach($groups as $group)
                                                                    @if(isset($bank))
                                                                        <option
                                                                            value="{{$group->id}}" {{$group->id == $bank->group_id? 'selected': ''}}>{{$group->title}}</option>
                                                                    @else
                                                                        <option
                                                                            value="{{$group->id}}" {{old('group')!=''? (old('group') == $group->id? 'selected':''):''}} >{{$group->title}}</option>
                                                                    @endif

                                                                @endforeach
                                                            </select>
                                                            @if ($errors->has('group'))
                                                                <span class="invalid-feedback invalid-select"
                                                                      role="alert">
                                            <strong>{{ $errors->first('group') }}</strong>
                                        </span>
                                                            @endif
                                                        </div>
                                                        <div class="col-lg-4">
                                                            <label class="primary_input_label"
                                                                   for="category_id">{{__('quiz.Category')}} <span
                                                                    class='required_mark'>*</span></label>
                                                            <select {{ $errors->has('category') ? ' autofocus' : '' }}
                                                                    class="primary_select {{ $errors->has('category') ? ' is-invalid' : '' }}"
                                                                    id="category_id" name="category">
                                                                <option data-display=" {{__('quiz.Category')}}"
                                                                        value=""> {{__('quiz.Category')}}
                                                                </option>
                                                                @foreach($categories as $category)
                                                                    @if(isset($bank))
                                                                        <option
                                                                            value="{{$category->id}}" {{$bank->category_id == $category->id? 'selected': ''}}>{{$category->name}}</option>
                                                                    @else
                                                                        <option
                                                                            value="{{$category->id}}" {{old('category')!=''? (old('category') == $category->id? 'selected':''):''}}>{{$category->name}}</option>
                                                                    @endif

                                                                @endforeach
                                                            </select>
                                                            @if ($errors->has('category'))
                                                                <span class="invalid-feedback invalid-select"
                                                                      role="alert">
                                            <strong>{{ $errors->first('category') }}</strong>
                                        </span>
                                                            @endif
                                                        </div>
                                                        <div class="col-lg-4 mt-30-md" id="subCategoryDiv">
                                                            <label class="primary_input_label"
                                                                   for="subcategory_id">{{__('quiz.Sub Category')}}</label>
                                                            <select
                                                                {{ $errors->has('sub_category') ? ' autofocus' : '' }}
                                                                class="primary_select{{ $errors->has('sub_category') ? ' is-invalid' : '' }} select_section"
                                                                id="subcategory_id" name="sub_category">
                                                                <option
                                                                    data-display=" {{__('common.Select')}} {{__('quiz.Sub Category')}}"
                                                                    value="">{{__('common.Select')}} {{__('quiz.Sub Category')}}
                                                                </option>

                                                                @if(isset($bank))
                                                                    <option value="{{@$bank->subcategory_id}}"
                                                                            selected>{{@$bank->subCategory->name}}</option>
                                                                @endif
                                                            </select>
                                                            @if ($errors->has('sub_category'))
                                                                <span class="invalid-feedback invalid-select"
                                                                      role="alert">
                                            <strong>{{ $errors->first('sub_category') }}</strong>
                                        </span>
                                                            @endif
                                                        </div>
                                                    </div>
                                                    {{-- <input type="hidden" name="question_type" value="M"> --}}
                                                    <div class="row mt-25">
                                                        <div class="col-lg-4">
                                                            <label class="primary_input_label"
                                                                   for="question-type">{{__('survey.Survey Type')}}
                                                                <span
                                                                    class='required_mark'>*</span></label>
                                                            <select
                                                                {{ $errors->has('question_type') ? ' autofocus' : '' }}
                                                                class="primary_select{{ $errors->has('question_type') ? ' is-invalid' : '' }}"
                                                                name="question_type" id="question-type">
                                                                <option data-display="{{__('survey.Survey Type')}} "
                                                                        value="">{{__('survey.Survey Type')}}
                                                                </option>

                                                                <option
                                                                    value="checkbox" {{isset($bank)? $bank->type == "checkbox"? 'selected': '' : ''}}> {{__('survey.Checkbox')}}</option>
                                                                <option
                                                                    value="dropdown" {{isset($bank)? $bank->type == "dropdown"? 'selected': '' : ''}}> {{__('survey.Dropdown')}}</option>
                                                                <option
                                                                    value="radio" {{isset($bank)? $bank->type == "radio"? 'selected': '' : ''}}> {{__('survey.Radio')}}</option>
                                                                <option
                                                                    value="textarea" {{isset($bank)? $bank->type == "textarea"? 'selected': '' : ''}}> {{__('survey.TextArea')}}</option>
                                                                <option
                                                                    value="linear_scale" {{isset($bank)? $bank->type == "linear_scale"? 'selected': '' : ''}}> {{__('survey.Linear Scale')}}</option>

                                                            </select>
                                                            @if ($errors->has('question_type'))
                                                                <span class="invalid-feedback invalid-select"
                                                                      role="alert">
                                            <strong>{{ $errors->first('question_type') }}</strong>
                                        </span>
                                                            @endif
                                                        </div>


                                                        <div class="col-lg-4  linear-options">
                                                            <label class="primary_input_label"
                                                                   for="linear_option">{{__('survey.Linear Option')}}
                                                                <span
                                                                    class='required_mark'>*</span></label>
                                                            <select
                                                                {{ $errors->has('question_type') ? ' autofocus' : '' }}
                                                                class="primary_select"
                                                                name="linear_option" id="linear_option">
                                                                <option data-display="{{__('survey.Survey Type')}}"
                                                                        value="">{{__('survey.Survey Type')}}
                                                                </option>
                                                                @for($i=1;$i<=10;$i++)
                                                                    <option
                                                                        {{isset($bank)?$bank->number_of_option==$i?'selected':'':''}}
                                                                        value="{{$i}}"> 1-{{$i}}
                                                                    </option>
                                                                @endfor
                                                            </select>

                                                        </div>
                                                        <div class="col-xl-4">


                                                            <x-upload-file
                                                                name="image"
                                                                type="image"
                                                                media_id="{{isset($bank)?$bank->image_media?->media_id:''}}"
                                                                label="{{__('quiz.Image') }}  ({{__('common.Optional')}})"/>
                                                        </div>


                                                    </div>
                                                    <div class="row mt-25">
                                                        <div class="col-lg-12">
                                                            <div class="input-effect">
                                                                <label
                                                                    class="primary_input_label mt-1"> {{__('quiz.Question')}}
                                                                    <span
                                                                        class='required_mark'>*</span></label>
                                                                <textarea
                                                                    class="textArea lms_summernote {{ @$errors->has('details') ? ' is-invalid' : '' }}"
                                                                    cols="30" rows="10"
                                                                    name="question">{{isset($bank)? $bank->question:(old('question')!=''?(old('question')):'')}}</textarea>

                                                                <span class="focus-border textarea"></span>
                                                                @if ($errors->has('question'))
                                                                    <span
                                                                        class="error text-danger"><strong>{{ $errors->first('question') }}</strong></span>
                                                                @endif
                                                            </div>
                                                        </div>
                                                    </div>


                                                    @php
                                                        if(!isset($bank)){
                                                            if(in_array(old('question_type'),$options)){
                                                                $multiple_choice = "";
                                                                  $multiple_options = "";
                                                            }
                                                        }else{
                                                            if(in_array($bank->type,$options)  || in_array(old('question_type'),$options)){
                                                                $multiple_choice = "";
                                                                  $multiple_options = "";
                                                            }
                                                        }
                                                    @endphp
                                                    <div class="survey-multiple-choice"
                                                         id="{{isset($multiple_choice)? $multiple_choice: 'survey-multiple-choice'}}">
                                                        <div class="row  mt-25">
                                                            <div class="col-lg-8">
                                                                <div class="input-effect">
                                                                    <label
                                                                        class="primary_input_label mt-1"> {{__('quiz.Number Of Options')}}
                                                                        *</label>
                                                                    <input
                                                                        {{ $errors->has('number_of_option') ? ' autofocus' : '' }}
                                                                        class="primary_input_field name{{ $errors->has('number_of_option') ? ' is-invalid' : '' }}"
                                                                        type="number" name="number_of_option"
                                                                        autocomplete="off"
                                                                        id="number_of_option"
                                                                        value="{{isset($bank)? $bank->number_of_option: ''}}">
                                                                    <span class="focus-border"></span>
                                                                    @if ($errors->has('number_of_option'))
                                                                        <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $errors->first('number_of_option') }}</strong>
                                                </span>
                                                                    @endif
                                                                </div>
                                                            </div>
                                                            <div class="col-lg-2 mt_30">
                                                                <button type="button" class="primary-btn   fix-gr-bg"
                                                                        id="create-option">{{__('quiz.Create')}} </button>
                                                            </div>
                                                        </div>


                                                    </div>

                                                    <div
                                                        class="multiple-options"
                                                        id="{{isset($multiple_options)? "": 'multiple-options'}}"
                                                    >
                                                        @php
                                                            $i=0;
                                                            $multiple_options = [];

                                                            if(isset($bank)){
                                                                  $options = [
                                                                    'checkbox',
                                                                    'dropdown',
                                                                    'radio'
                                                                ];
                                                                if(in_array($bank->type, $options)){
                                                                    $multiple_options = $bank->questionMu;
                                                                }
                                                            }

                                                        @endphp
                                                        @foreach($multiple_options as $key=>$multiple_option)

                                                            <div class='row  mt-25'>
                                                                <div class='col-lg-12'>
                                                                    <div class='input-effect'>
                                                                        <label
                                                                            class="primary_input_label mt-1"> {{__('quiz.Option')}} {{++$key}}</label>
                                                                        <input class='primary_input_field name'
                                                                               type='text'
                                                                               name='option[]' autocomplete='off'
                                                                               required
                                                                               value="{{$multiple_option->title}}">
                                                                        <span class='focus-border'></span>
                                                                    </div>
                                                                </div>

                                                            </div>
                                                        @endforeach
                                                    </div>


                                                    <div class="row mt-3">
                                                        <div
                                                            class="col-lg-12 d-flex justify-content-center align-items-center">
                                                            <button type="submit" class="primary-btn fix-gr-bg">
                                                                <i class="ti-check"></i>
                                                                @if(isset($bank))
                                                                    {{__('common.Update')}}
                                                                @else
                                                                    {{__('common.Save')}}
                                                                @endif
                                                                {{__('quiz.Question')}}
                                                            </button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

@endsection
@push('scripts')
    <script>

        (function ($) {
            "use strict";
            $('#question-type').change(function (e) {
                var type = $('#question-type').val();

                if (type == "" || type == 'textarea') {
                    $('.survey-multiple-choice').hide();
                    $('.multiple-options').hide();
                    $('.linear-options').hide();
                } else if (type == 'linear_scale') {
                    $('.survey-multiple-choice').hide();
                    $('.multiple-options').hide();
                    $('.linear-options').show();

                } else {
                    $('.linear-options').hide();
                    $('.multiple-options').show();
                    $('.survey-multiple-choice').show();
                }


            });

            $('#question-type').trigger('change');

        })(jQuery);

    </script>
    <script src="{{asset('/')}}/Modules/CourseSetting/Resources/assets/js/course.js"></script>
@endpush


