@extends('backend.master')

@section('mainContent')

    {!! generateBreadcrumb() !!}

    <section class="admin-visitor-area up_st_admin_visitor">
        <div class="container-fluid p-0">
            <div class="row">
                <div class="col-lg-12">
                    <div class="white-box">

                        <div class="main-title">
                            <h3 class="mb-30">{{__('common.Select')}} {{__('survey.Criteria')}}</h3>
                        </div>

                        <form method="POST" action="{{ route('survey.question_based_report_search', $survey->id) }}"
                              class="form-horizontal" enctype="multipart/form-data">
                            @csrf
                            <div class="row">
                                <div class="col-lg-8 mt-30-md">
                                    <select
                                        class="niceSelect w-100 bb form-control {{ $errors->has('role_id') ? ' is-invalid' : '' }}"
                                        name="question_id">
                                        <option value="">{{__('common.Select')}} {{__('quiz.Question')}}</option>
                                        @foreach ($survey->questionAssigns as $assign)
                                            @php
                                                $question= $assign->questionBank;
                                                 if($question->type=='textarea'){
                                                     continue;
                                                 }
                                            @endphp
                                            <option
                                                {{isset($selected_question)? $selected_question->id==$question->id ? 'selected':'' :''}} value="{{$question->id}}">{!! $question->question !!}</option>

                                        @endforeach
                                    </select>
                                    @if ($errors->has('role_id'))
                                        <span class="invalid-feedback invalid-select" role="alert">
                            <strong>{{ $errors->first('role_id') }}</strong>
                        </span>
                                    @endif
                                </div>
                                <div class="col-lg-4 mt-30-md">
                                    <button type="submit" class="primary-btn small fix-gr-bg">
                                        <span class="ti-search pe-2"></span>
                                        {{__('common.Search')}}
                                    </button>
                                </div>

                            </div>
                        </form>
                    </div>
                </div>
            </div>
            <div class="row mt-20">
                <div class="col-lg-12">
                    <div class="white-box mb-30">
                        <div class="row justify-content-center">
                            <div class="col-12">
                                <div class="box_header common_table_header">
                                    <div class="main-title d-flex flex-wrap mb-0">
                                        <h3 class="mb-0 mr-30 mb_xs_15px mb_sm_20px"
                                            id="page_title">{{__('survey.Survey')}} {{__('survey.Participation')}}
                                            - {{$survey->title}} </h3>

                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-lg-12 text-center">
                                <h2>
                                    {{$survey->title}}
                                </h2>
                                {!! $survey->description !!}
                                @if (isset($selected_question))
                                    <h3 class="mt-5">{{__('quiz.Question')}}: {{@$selected_question->title}}</h3>
                                @endif
                            </div>
                        </div>
                    </div>


                </div>

            </div>
        </div>
        @if (isset($submitted_answers))
            <div class="mt-30">
                <div class="QA_section QA_section_heading_custom check_box_table">
                    <div class="QA_table ">
                        <!-- table-responsive -->
                        <div class="">
                            <table id="lms_table" class="table Crm_table_active3">
                                <thead>
                                <tr>
                                    <th scope="col">{{__('common.SL')}}</th>
                                    <th scope="col">{{__('common.Name')}}</th>
                                    <th scope="col">{{__('homework.Answer')}}</th>
                                </tr>
                                </thead>
                                <tbody>
                                @foreach ($submitted_answers as $key => $answer)
                                    <tr>
                                        <td>
                                            {{++$key}}
                                        </td>
                                        <td>
                                            {{$answer->user->name}}
                                        </td>
                                        <td>
                                            @if ($selected_question->type =='textarea')
                                                {!! $answer->answer !!}
                                            @else
                                                {{@$answer->questionMu->title}}
                                            @endif

                                        </td>
                                    </tr>
                                @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        @else
            <div class="mt-30 white-box">
                <div class="QA_section QA_section_heading_custom check_box_table">
                    <div class="QA_table ">
                        <h2 class="text-center"> {{__('common.Please')}}  {{__('common.Select')}} {{__('quiz.Question')}}</h2>
                    </div>
                </div>
            </div>
        @endif

    </section>

@endsection
@push('scripts')
    <script src="{{asset('Modules/Survey/Resources/assets/js/survey.js')}}"></script>

    <script>
        (function ($) {
            "use strict";
            dataTableOptions = updateColumnExportOption(dataTableOptions, [0, 1, 2]);

            $('#lms_table').DataTable(dataTableOptions);
        })(jQuery);


    </script>
@endpush
