<?php

namespace Modules\Survey\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Brian2694\Toastr\Facades\Toastr;
use Illuminate\Contracts\Support\Renderable;
use Modules\Survey\Entities\SurveyQuestionSet;
use Modules\Survey\Entities\SurveyQuestionSetAttribute;

class QuestionSetAttributeController extends Controller
{
    public function index()
    {
        return view('survey::index');
    }

    public function getSetAttributeList($set_id)
    {
        $set_info=SurveyQuestionSet::find($set_id);
        return view('survey::attribute.set_attributes',compact('set_info'));
    }


    public function create()
    {
        return view('survey::create');
    }


    public function store(Request $request)
    {
        $rules = [
            'name' => 'required',
            'set_id' => 'required',
        ];

        $request->validate($rules, validationMessage($rules));
       try {
          $attribute=new SurveyQuestionSetAttribute();
          $attribute->name=$request->name;
          $attribute->set_id=$request->set_id;
          $attribute->save();
            Toastr::success(trans('common.Operation successful'), trans('common.Success'));
            return redirect()->back();
       } catch (\Throwable $th) {
           Toastr::error(trans('common.Operation failed'), trans('common.Failed'));
            return redirect()->back();
       }
    }

    public function show($id)
    {
        return view('survey::show');
    }

    public function edit($set_id,$attribute_id)
    {
        $set_info=SurveyQuestionSet::find($set_id);
        $edit=SurveyQuestionSetAttribute::find($attribute_id);
        return view('survey::attribute.set_attributes',compact('set_info','edit'));
    }

    public function update(Request $request)
    {
        $rules = [
            'name' => 'required',
            'id' => 'required',
        ];
        $request->validate($rules, validationMessage($rules));
       try {
          $attribute=SurveyQuestionSetAttribute::find($request->id);
          $attribute->name=$request->name;
          $attribute->save();
            Toastr::success(trans('common.Operation successful'), trans('common.Success'));
            return redirect()->route('survey.set_attribute',$attribute->set_id);
       } catch (\Throwable $th) {
           Toastr::error(trans('common.Operation failed'), trans('common.Failed'));
            return redirect()->back();
       }
    }

    public function destroy($id)
    {
       try {
            $attribute=SurveyQuestionSetAttribute::find($id);
            $attribute->delete();
            Toastr::success(trans('common.Operation successful'), trans('common.Success'));
            return redirect()->route('survey.set_attribute',$attribute->set_id);
       } catch (\Throwable $th) {
           Toastr::error(trans('common.Operation failed'), trans('common.Failed'));
            return redirect()->back();
       }
    }
}
